/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.valuegenerator.AbstractConnectedGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.Localiser;

public final class DatastoreUUIDHexGenerator
extends AbstractConnectedGenerator<String> {
    public DatastoreUUIDHexGenerator(StoreManager storeMgr, String name, Properties props) {
        super(storeMgr, name, props);
        this.allocationSize = 10;
        if (this.properties != null && this.properties.containsKey("key-cache-size")) {
            try {
                this.allocationSize = Integer.parseInt((String)this.properties.get("key-cache-size"));
            }
            catch (Exception e) {
                throw new ValueGenerationException(Localiser.msg((String)"040006", (Object[])new Object[]{this.properties.get("key-cache-size")}));
            }
        }
    }

    public static Class getStorageClass() {
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized ValueGenerationBlock<String> reserveBlock(long size) {
        if (size < 1L) {
            return null;
        }
        ArrayList<String> oids = new ArrayList<String>();
        try {
            ManagedConnection mconn = this.connectionProvider.retrieveConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            RDBMSStoreManager rdbmsMgr = (RDBMSStoreManager)this.storeMgr;
            SQLController sqlControl = rdbmsMgr.getSQLController();
            try {
                DatastoreAdapter dba = rdbmsMgr.getDatastoreAdapter();
                String stmt = dba.getSelectNewUUIDStmt();
                ps = sqlControl.getStatementForQuery(mconn, stmt);
                int i = 1;
                while ((long)i < size) {
                    rs = sqlControl.executeStatementQuery(null, mconn, stmt, ps);
                    if (rs.next()) {
                        oids.add(rs.getString(1));
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new ValueGenerationException(Localiser.msg((String)"040008", (Object[])new Object[]{e.getMessage()}));
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            this.connectionProvider.releaseConnection();
        }
        return new ValueGenerationBlock(oids);
    }
}

