/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.PersistencePropertiesEnum;
import co.codewizards.cloudstore.local.PersistencePropertiesProvider;
import co.codewizards.cloudstore.local.db.AbstractDatabaseAdapter;
import co.codewizards.cloudstore.local.db.AbstractDatabaseAdapterFactory;
import co.codewizards.cloudstore.local.db.ExternalJdbcDatabaseAdapterFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalJdbcDatabaseAdapter
extends AbstractDatabaseAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ExternalJdbcDatabaseAdapter.class);
    public static final String CONFIG_KEY_JDBC_HOST_NAME = "jdbc.hostName";
    public static final String CONFIG_KEY_JDBC_USER_NAME = "jdbc.userName";
    public static final String CONFIG_KEY_JDBC_PASSWORD = "jdbc.password";
    public static final String CONFIG_KEY_JDBC_DB_NAME_PREFIX = "jdbc.dbNamePrefix";
    public static final String CONFIG_KEY_JDBC_DB_NAME_SUFFIX = "jdbc.dbNameSuffix";
    public static final String CONFIG_KEY_JDBC_SYSDB_NAME = "jdbc.sysdbName";
    private Map<String, String> persistenceProperties;
    private String connectionURL;
    private String connectionDriverName;
    private String connectionUserName;
    private String connectionPassword;
    private String databaseName;

    @Override
    protected void setFactory(AbstractDatabaseAdapterFactory factory) {
        if (factory != null && !(factory instanceof ExternalJdbcDatabaseAdapterFactory)) {
            throw new IllegalArgumentException("factory is not an instance of ExternalJdbcDatabaseAdapterFactory: " + factory);
        }
        super.setFactory(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createDatabase() throws Exception {
        if (this.connectionURL == null) {
            this.initProperties();
            this.initDriverClass();
        }
        Config config = ConfigImpl.getInstance();
        ExternalJdbcDatabaseAdapterFactory factory = (ExternalJdbcDatabaseAdapterFactory)this.getFactoryOrFail();
        String sysdbUrl = factory.getJdbcSysdbUrl();
        String userName = config.getPropertyAsNonEmptyTrimmedString(CONFIG_KEY_JDBC_USER_NAME, null);
        String password = config.getPropertyAsNonEmptyTrimmedString(CONFIG_KEY_JDBC_PASSWORD, null);
        String dbNamePrefix = config.getPropertyAsNonEmptyTrimmedString(CONFIG_KEY_JDBC_DB_NAME_PREFIX, "");
        String dbNameSuffix = config.getPropertyAsNonEmptyTrimmedString(CONFIG_KEY_JDBC_DB_NAME_SUFFIX, "");
        this.databaseName = dbNamePrefix + this.getRepositoryIdOrFail() + dbNameSuffix;
        try (Connection connection = DriverManager.getConnection(sysdbUrl, userName, password);){
            boolean dropDatabase = true;
            this.createDatabase(connection, this.databaseName);
            try {
                try {
                    Connection newDbConnection = this.createConnection();
                    newDbConnection.close();
                }
                catch (Exception x) {
                    logger.error("Creating connection failed: " + x, (Throwable)x);
                    throw x;
                }
                dropDatabase = false;
            }
            finally {
                try {
                    if (dropDatabase) {
                        this.dropDatabase(connection, this.databaseName);
                    }
                }
                catch (Throwable error) {
                    logger.error("Dropping database '" + this.databaseName + "' failed: " + error, error);
                }
            }
        }
    }

    protected void dropDatabase() throws Exception {
        if (StringUtil.isEmpty((String)this.databaseName)) {
            throw new IllegalStateException("createDatabase() not called immediately before!");
        }
        logger.warn("dropDatabase: Dropping '{}'...", (Object)this.databaseName);
        Config config = ConfigImpl.getInstance();
        ExternalJdbcDatabaseAdapterFactory factory = (ExternalJdbcDatabaseAdapterFactory)this.getFactoryOrFail();
        String userName = config.getPropertyAsNonEmptyTrimmedString(CONFIG_KEY_JDBC_USER_NAME, null);
        String password = config.getPropertyAsNonEmptyTrimmedString(CONFIG_KEY_JDBC_PASSWORD, null);
        String sysdbUrl = factory.getJdbcSysdbUrl();
        try (Connection connection = DriverManager.getConnection(sysdbUrl, userName, password);){
            this.dropDatabase(connection, this.databaseName);
        }
        logger.warn("dropDatabase: Dropped '{}'!", (Object)this.databaseName);
        this.databaseName = null;
    }

    protected void createDatabase(Connection connection, String databaseName) throws Exception {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(databaseName, "databaseName");
        if (databaseName.indexOf(34) >= 0) {
            throw new IllegalStateException("databaseName contains illegal character '\"': " + databaseName);
        }
        logger.info("createDatabase: Creating '{}'...", (Object)databaseName);
        try (Statement statement = connection.createStatement();){
            String sql = String.format("create database \"%s\"", databaseName);
            statement.execute(sql);
        }
        logger.info("createDatabase: Created '{}'!", (Object)databaseName);
    }

    protected void dropDatabase(Connection connection, String databaseName) throws Exception {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(databaseName, "databaseName");
        if (databaseName.indexOf(34) >= 0) {
            throw new IllegalStateException("databaseName contains illegal character '\"': " + databaseName);
        }
        logger.info("dropDatabase: Dropping '{}'...", (Object)databaseName);
        try (Statement statement = connection.createStatement();){
            String sql = String.format("drop database \"%s\"", databaseName);
            statement.execute(sql);
        }
        logger.info("dropDatabase: Dropped '{}'!", (Object)databaseName);
    }

    private void initDriverClass() {
        if (StringUtil.isEmpty((String)this.connectionDriverName)) {
            return;
        }
        try {
            Class.forName(this.connectionDriverName);
        }
        catch (Throwable e) {
            logger.warn("initDriverClass: " + e, e);
        }
    }

    @Override
    public Connection createConnection() throws SQLException {
        if (this.connectionURL == null) {
            this.initProperties();
            this.initDriverClass();
        }
        if (StringUtil.isEmpty((String)this.connectionUserName) && StringUtil.isEmpty((String)this.connectionPassword)) {
            return DriverManager.getConnection(this.connectionURL);
        }
        return DriverManager.getConnection(this.connectionURL, this.connectionUserName, this.connectionPassword);
    }

    private void initProperties() {
        PersistencePropertiesProvider persistencePropertiesProvider = new PersistencePropertiesProvider(this.getRepositoryIdOrFail(), this.getLocalRootOrFail());
        this.persistenceProperties = persistencePropertiesProvider.getPersistenceProperties();
        this.connectionDriverName = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_DRIVER_NAME.key);
        this.connectionURL = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_URL.key);
        this.connectionUserName = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_USER_NAME.key);
        this.connectionPassword = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_PASSWORD.key);
    }
}

