/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.oio;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.FileFactory;
import co.codewizards.cloudstore.core.oio.OioRegistry;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;

public class OioFileFactory {
    public static final String FILE_SEPARATOR = java.io.File.separator;
    public static final char FILE_SEPARATOR_CHAR = java.io.File.separatorChar;

    public static File createFile(String pathname) {
        return OioRegistry.getInstance().getFileFactory().createFile(pathname);
    }

    public static File createFile(String parent, String ... children) {
        Objects.requireNonNull(parent, "parent");
        FileFactory fileFactory = OioRegistry.getInstance().getFileFactory();
        File result = null;
        if (children != null) {
            for (String child : children) {
                result = result == null ? fileFactory.createFile(parent, child) : fileFactory.createFile(result, child);
            }
        }
        if (result == null) {
            result = OioFileFactory.createFile(parent);
        }
        return result;
    }

    public static File createFile(File parent, String ... children) {
        Objects.requireNonNull(parent, "parent");
        FileFactory fileFactory = OioRegistry.getInstance().getFileFactory();
        File result = parent;
        if (children != null) {
            for (String child : children) {
                result = fileFactory.createFile(result, child);
            }
        }
        return result;
    }

    public static File createFile(java.io.File file) {
        return OioRegistry.getInstance().getFileFactory().createFile(file);
    }

    public static File createFile(URI uri) {
        return OioRegistry.getInstance().getFileFactory().createFile(uri);
    }

    public static File createTempDirectory(String prefix) throws IOException {
        return OioRegistry.getInstance().getFileFactory().createTempDirectory(prefix);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return OioRegistry.getInstance().getFileFactory().createTempFile(prefix, suffix);
    }

    public static File createTempFile(String prefix, String suffix, File dir) throws IOException {
        return OioRegistry.getInstance().getFileFactory().createTempFile(prefix, suffix, dir);
    }

    public static File[] listRootFiles() {
        return OioRegistry.getInstance().getFileFactory().listRootFiles();
    }
}

