/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke.filter;

import co.codewizards.cloudstore.ls.core.invoke.filter.ExtMethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.filter.InvocationFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public class InvocationFilterRegistry {
    private List<Class<? extends InvocationFilter>> invocationFilterClasses;

    private InvocationFilterRegistry() {
    }

    public static InvocationFilterRegistry getInstance() {
        return Holder.instance;
    }

    private List<InvocationFilter> loadInvocationFilters() {
        ArrayList<InvocationFilter> result = new ArrayList<InvocationFilter>();
        Iterator<InvocationFilter> iterator = ServiceLoader.load(InvocationFilter.class).iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        Collections.sort(result, new Comparator<InvocationFilter>(){

            @Override
            public int compare(InvocationFilter o1, InvocationFilter o2) {
                int result = -1 * Integer.compare(o1.getPriority(), o2.getPriority());
                if (result != 0) {
                    return result;
                }
                result = o1.getClass().getName().compareTo(o2.getClass().getName());
                return result;
            }
        });
        return result;
    }

    protected List<Class<? extends InvocationFilter>> getInvocationFilterClasses() {
        if (this.invocationFilterClasses == null) {
            List<InvocationFilter> invocationFilters = this.loadInvocationFilters();
            ArrayList l = new ArrayList(invocationFilters.size());
            for (InvocationFilter invocationFilter : invocationFilters) {
                l.add(invocationFilter.getClass());
            }
            this.invocationFilterClasses = Collections.unmodifiableList(l);
        }
        return this.invocationFilterClasses;
    }

    protected List<InvocationFilter> getInvocationFilters() {
        List<Class<? extends InvocationFilter>> invocationFilterClasses = this.getInvocationFilterClasses();
        ArrayList<InvocationFilter> result = new ArrayList<InvocationFilter>(invocationFilterClasses.size());
        for (Class<? extends InvocationFilter> invocationFilterClass : invocationFilterClasses) {
            result.add(this.newInstance(invocationFilterClass));
        }
        return Collections.unmodifiableList(result);
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canInvoke(ExtMethodInvocationRequest extMethodInvocationRequest) {
        Objects.requireNonNull(extMethodInvocationRequest, "extMethodInvocationRequest");
        for (InvocationFilter invocationFilter : this.getInvocationFilters()) {
            Boolean result = invocationFilter.canInvoke(extMethodInvocationRequest);
            if (result == null) continue;
            return result;
        }
        return false;
    }

    public void assertCanInvoke(ExtMethodInvocationRequest extMethodInvocationRequest) {
        if (!this.canInvoke(extMethodInvocationRequest)) {
            throw new SecurityException("Invocation denied: " + extMethodInvocationRequest.getMethodInvocationRequest());
        }
    }

    private static final class Holder {
        public static final InvocationFilterRegistry instance = new InvocationFilterRegistry();

        private Holder() {
        }
    }
}

