/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.local.PersistencePropertiesEnum;
import co.codewizards.cloudstore.local.db.AbstractDatabaseAdapterFactory;
import co.codewizards.cloudstore.local.db.DatabaseAdapter;
import co.codewizards.cloudstore.local.db.DerbyDatabaseAdapter;
import java.util.Objects;
import java.util.Properties;

public class DerbyDatabaseAdapterFactory
extends AbstractDatabaseAdapterFactory {
    @Override
    public String getName() {
        return "derby";
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    protected DatabaseAdapter _createDatabaseAdapter() {
        return new DerbyDatabaseAdapter();
    }

    @Override
    public boolean isLocalRootSupported(File localRoot) {
        Objects.requireNonNull(localRoot, "localRoot");
        Properties properties = this.readRawPersistenceProperties(localRoot);
        String connectionDriverName = properties.getProperty(PersistencePropertiesEnum.CONNECTION_DRIVER_NAME.key);
        if (connectionDriverName == null) {
            return false;
        }
        return connectionDriverName.indexOf(".derby.") >= 0;
    }
}

