/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.dbupdate;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.local.db.DatabaseAdapter;
import co.codewizards.cloudstore.local.dbupdate.DatabaseType;
import co.codewizards.cloudstore.local.dbupdate.DbUpdateStep;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDbUpdateStep
implements DbUpdateStep {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDbUpdateStep.class);
    private DatabaseAdapter databaseAdapter;

    @Override
    public int getOrderHint() {
        return 1000;
    }

    @Override
    public DatabaseAdapter getDatabaseAdapter() {
        return this.databaseAdapter;
    }

    @Override
    public void setDatabaseAdapter(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    protected DatabaseAdapter getDatabaseAdapterOrFail() {
        return Objects.requireNonNull(this.getDatabaseAdapter(), "databaseAdapter");
    }

    protected File getLocalRoot() {
        return this.getDatabaseAdapterOrFail().getLocalRoot();
    }

    protected File getMetaDir() {
        return this.getLocalRoot().createFile(new String[]{LocalRepoManager.META_DIR_NAME});
    }

    protected File getPersistencePropertiesFile() {
        File persistencePropertiesFile = this.getMetaDir().createFile(new String[]{LocalRepoManager.PERSISTENCE_PROPERTIES_FILE_NAME});
        if (!persistencePropertiesFile.isFile()) {
            throw new IllegalStateException("The persistencePropertiesFile does not exist or is not a file: " + persistencePropertiesFile.getAbsolutePath());
        }
        return persistencePropertiesFile;
    }

    protected Connection createConnection() throws Exception {
        return this.getDatabaseAdapterOrFail().createConnection();
    }

    protected static DatabaseType getDatabaseType(Connection connection) throws SQLException {
        String driverName = connection.getMetaData().getDriverName();
        if (driverName == null) {
            logger.error("getDatabaseType: connection.getMetaData().getDriverName() returned null!");
            return DatabaseType.OTHER;
        }
        logger.info("getDatabaseType: driverName='{}'", (Object)driverName);
        String driverNameLowerCase = driverName.toLowerCase(Locale.UK);
        if (driverNameLowerCase.contains("derby")) {
            return DatabaseType.DERBY;
        }
        if (driverNameLowerCase.contains("postgre")) {
            return DatabaseType.POSTGRESQL;
        }
        return DatabaseType.OTHER;
    }

    protected static boolean doesTableExist(Connection connection, String tableName) throws SQLException {
        try (ResultSet rs = connection.getMetaData().getTables(null, null, tableName.toLowerCase(Locale.UK), new String[]{"TABLE"});){
            boolean result = rs.next();
            logger.info("doesTableExist: tableName='{}' result={}", (Object)tableName, (Object)result);
            boolean bl = result;
            return bl;
        }
    }

    protected static boolean doesColumnExist(Connection connection, String tableName, String columnName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery("select * from " + AbstractDbUpdateStep.quoteIdentifier(tableName) + " where 1 = 0");
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                String cn = metaData.getColumnName(columnIndex);
                if (!columnName.equalsIgnoreCase(cn)) continue;
                logger.info("doesColumnExist: tableName='{}' columnName='{}' result=true", (Object)tableName, (Object)columnName);
                boolean bl = true;
                return bl;
            }
        }
        logger.info("doesColumnExist: tableName='{}' columnName='{}' result=false", (Object)tableName, (Object)columnName);
        return false;
    }

    protected static String quoteIdentifier(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        return "\"" + identifier.toLowerCase(Locale.UK) + "\"";
    }

    protected static void addColumnBooleanNotNull(Connection connection, String tableName, String columnName) throws SQLException {
        String sql;
        DatabaseType databaseType = AbstractDbUpdateStep.getDatabaseType(connection);
        switch (databaseType) {
            case DERBY: {
                sql = "ALTER TABLE " + AbstractDbUpdateStep.quoteIdentifier(tableName) + " ADD COLUMN " + AbstractDbUpdateStep.quoteIdentifier(columnName) + " CHAR(1) NOT NULL DEFAULT 'N' CHECK (" + AbstractDbUpdateStep.quoteIdentifier(columnName) + " IN ('Y','N'))";
                break;
            }
            default: {
                throw new IllegalStateException("Not yet supported for databaseType=" + (Object)((Object)databaseType));
            }
        }
        try (Statement statement = connection.createStatement();){
            logger.info("addColumnBooleanNotNull: SQL=>>{}<<", (Object)sql);
            statement.executeUpdate(sql);
        }
    }
}

