/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.crypto;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.subshare.core.dto.CryptoKeyType;

public enum CipherTransformation {
    AES_CBC_PKCS5PADDING(CryptoKeyType.symmetric, "AES/CBC/PKCS5Padding"),
    AES_CBC_PKCS7PADDING(CryptoKeyType.symmetric, "AES/CBC/PKCS7Padding"),
    AES_CFB_NOPADDING(CryptoKeyType.symmetric, "AES/CFB/NoPadding"),
    TWOFISH_CBC_PKCS5PADDING(CryptoKeyType.symmetric, "Twofish/CBC/PKCS5Padding"),
    TWOFISH_CBC_PKCS7PADDING(CryptoKeyType.symmetric, "Twofish/CBC/PKCS7Padding"),
    TWOFISH_CFB_NOPADDING(CryptoKeyType.symmetric, "Twofish/CFB/NoPadding"),
    RSA_OAEPWITHSHA1ANDMGF1PADDING(CryptoKeyType.asymmetric, "RSA//OAEPWITHSHA1ANDMGF1PADDING");

    private static final Map<String, CipherTransformation> transformation2CipherTransformation;
    private final CryptoKeyType type;
    private final String transformation;
    public static final String CONFIG_KEY_ASYMMETRIC = "asymmetricCipherTransformation";
    public static final CipherTransformation CONFIG_DEFAULT_VALUE_ASYMMETRIC;
    public static final String CONFIG_KEY_SYMMETRIC = "symmetricCipherTransformation";
    public static final CipherTransformation CONFIG_DEFAULT_VALUE_SYMMETRIC;

    private CipherTransformation(CryptoKeyType type, String transformation) {
        this.type = Objects.requireNonNull(type, "type");
        this.transformation = Objects.requireNonNull(transformation, "transformation");
    }

    public String getTransformation() {
        return this.transformation;
    }

    public CryptoKeyType getType() {
        return this.type;
    }

    public static CipherTransformation fromTransformation(String transformation) {
        Objects.requireNonNull(transformation, "transformation");
        CipherTransformation ct = transformation2CipherTransformation.get(transformation);
        if (ct == null) {
            throw new IllegalArgumentException("There is no CipherTransformation for this transformation: " + transformation);
        }
        return ct;
    }

    static {
        HashMap<String, CipherTransformation> m = new HashMap<String, CipherTransformation>(CipherTransformation.values().length);
        for (CipherTransformation ct : CipherTransformation.values()) {
            m.put(ct.getTransformation(), ct);
        }
        transformation2CipherTransformation = Collections.unmodifiableMap(m);
        CONFIG_DEFAULT_VALUE_ASYMMETRIC = RSA_OAEPWITHSHA1ANDMGF1PADDING;
        CONFIG_DEFAULT_VALUE_SYMMETRIC = TWOFISH_CFB_NOPADDING;
    }
}

