/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp;

import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpAuthenticationCallback;

public class PgpRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PgpRegistry.class);
    private Pgp pgp;
    private PgpAuthenticationCallback pgpAuthenticationCallback;

    protected PgpRegistry() {
    }

    public static PgpRegistry getInstance() {
        return Holder.instance;
    }

    @Deprecated
    public synchronized void clearCache() {
        logger.info("clearCache: entered.");
        if (this.pgp instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.pgp)).close();
            }
            catch (Exception e) {
                logger.error("clearCache: " + e, (Throwable)e);
            }
        }
        this.pgp = null;
    }

    public synchronized Pgp getPgpOrFail() {
        Pgp pgp = this.pgp;
        if (pgp == null) {
            for (Pgp p : ServiceLoader.load(Pgp.class)) {
                if (!p.isSupported() || pgp != null && pgp.getPriority() >= p.getPriority()) continue;
                pgp = p;
            }
            if (pgp == null) {
                throw new IllegalStateException("No supported Pgp implementation found!");
            }
            this.pgp = pgp;
        } else {
            logger.debug("getPgpOrFail: returning existing Pgp instance.");
        }
        return pgp;
    }

    public PgpAuthenticationCallback getPgpAuthenticationCallback() {
        return this.pgpAuthenticationCallback;
    }

    public void setPgpAuthenticationCallback(PgpAuthenticationCallback pgpAuthenticationCallback) {
        this.pgpAuthenticationCallback = pgpAuthenticationCallback;
    }

    private static final class Holder {
        public static final PgpRegistry instance = new PgpRegistry();

        private Holder() {
        }
    }
}

