/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.server;

import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockerDir {
    private static final Logger logger = LoggerFactory.getLogger(LockerDir.class);
    public static final String CONFIG_KEY_LOCKER_DIR = "locker.dir";
    public static final String DEFAULT_LOCKER_DIR = "${subshare.configDir}/locker";

    protected LockerDir() {
    }

    public static LockerDir getInstance() {
        return Holder.instance;
    }

    public File getFile() {
        String dirString = ConfigImpl.getInstance().getPropertyAsNonEmptyTrimmedString(CONFIG_KEY_LOCKER_DIR, DEFAULT_LOCKER_DIR);
        logger.debug("getFile: dirString={}", (Object)dirString);
        String resolvedDir = IOUtil.replaceTemplateVariables((String)dirString, (Map)System.getProperties());
        File result = OioFileFactory.createFile((String)resolvedDir).getAbsoluteFile();
        logger.debug("getFile: result={}", (Object)result);
        return result;
    }

    private static final class Holder {
        public static final LockerDir instance = new LockerDir();

        private Holder() {
        }
    }
}

