/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.auth;

import co.codewizards.cloudstore.core.auth.BouncyCastleRegistrationUtil;
import co.codewizards.cloudstore.core.auth.EncryptedSignedAuthToken;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SignedAuthTokenDecrypter {
    private PrivateKey privateKey;

    public SignedAuthTokenDecrypter(byte[] privateKeyData) {
        Objects.requireNonNull(privateKeyData, "privateKeyData");
        BouncyCastleRegistrationUtil.registerBouncyCastleIfNeeded();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyData);
            this.privateKey = keyFactory.generatePrivate(privateKeySpec);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] decrypt(EncryptedSignedAuthToken encryptedSignedAuthToken) {
        Objects.requireNonNull(encryptedSignedAuthToken, "encryptedSignedAuthToken");
        Objects.requireNonNull(encryptedSignedAuthToken.getEncryptedSignedAuthTokenData(), "encryptedSignedAuthToken.encryptedSignedAuthTokenData");
        Objects.requireNonNull(encryptedSignedAuthToken.getEncryptedSymmetricKey(), "encryptedSignedAuthToken.encryptedSymmetricKey");
        try {
            Cipher asymCipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING");
            asymCipher.init(2, this.privateKey);
            byte[] symKey = asymCipher.doFinal(encryptedSignedAuthToken.getEncryptedSymmetricKey());
            Cipher symCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            symCipher.init(2, (Key)new SecretKeySpec(symKey, "AES"), new IvParameterSpec(encryptedSignedAuthToken.getEncryptedSignedAuthTokenDataIV()));
            byte[] signedAuthTokenData = symCipher.doFinal(encryptedSignedAuthToken.getEncryptedSignedAuthTokenData());
            return signedAuthTokenData;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

