/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.local;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerCloseListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerException;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;

public interface LocalRepoManagerFactory {
    public LocalRepoManager createLocalRepoManagerForExistingRepository(File var1) throws LocalRepoManagerException;

    public LocalRepoManager createLocalRepoManagerForNewRepository(File var1) throws LocalRepoManagerException;

    public void close();

    public void addLocalRepoManagerCloseListener(LocalRepoManagerCloseListener var1);

    public void removeLocalRepoManagerCloseListener(LocalRepoManagerCloseListener var1);

    public Set<File> getLocalRoots();

    public static class Helper {
        private static LocalRepoManagerFactory instance;

        public static synchronized LocalRepoManagerFactory getInstance() {
            if (instance == null) {
                ServiceLoader<LocalRepoManagerFactory> serviceLoader = ServiceLoader.load(LocalRepoManagerFactory.class);
                Iterator<LocalRepoManagerFactory> iterator = serviceLoader.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalStateException("There is no LocalRepoManagerFactory implementation registered! Maybe the JAR 'co.codewizards.cloudstore.local' is missing in the classpath?!");
                }
                LocalRepoManagerFactory localRepoManagerFactory = iterator.next();
                if (iterator.hasNext()) {
                    throw new IllegalStateException("There are multiple LocalRepoManagerFactory implementations registered! Maybe there are multiple versions of JAR 'co.codewizards.cloudstore.local' in the classpath?!");
                }
                instance = localRepoManagerFactory;
            }
            return instance;
        }
    }
}

