/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.DateUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.db.IgnoreDatabaseMigraterComparison;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Objects;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchGroups;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.PermissionSet;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Unique(name="PermissionSetInheritance_permissionSetInheritanceId", members={"permissionSetInheritanceId"})
@Queries(value={@Query(name="getPermissionSetInheritance_permissionSetInheritanceId", value="SELECT UNIQUE WHERE this.permissionSetInheritanceId == :permissionSetInheritanceId"), @Query(name="getPermissionSetInheritancesChangedAfter_localRevision", value="SELECT WHERE this.localRevision > :localRevision")})
@FetchGroups(value={@FetchGroup(name="PermissionSetInheritanceDto", members={@Persistent(name="permissionSet"), @Persistent(name="signature")}), @FetchGroup(name="Signature", members={@Persistent(name="signature")})})
public class PermissionSetInheritance
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String permissionSetInheritanceId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private PermissionSet permissionSet;
    private long localRevision;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private Date validFrom = DateUtil.now();
    private Date revoked;
    private Date validTo;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final String[] dnFieldNames = PermissionSetInheritance.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = PermissionSetInheritance.__dnGetInheritedFieldCount();

    public PermissionSetInheritance() {
    }

    public PermissionSetInheritance(Uid permissionSetInheritanceId) {
        this.permissionSetInheritanceId = permissionSetInheritanceId == null ? null : permissionSetInheritanceId.toString();
    }

    public Uid getPermissionSetInheritanceId() {
        if (PermissionSetInheritance.dnGetpermissionSetInheritanceId(this) == null) {
            PermissionSetInheritance.dnSetpermissionSetInheritanceId(this, new Uid().toString());
        }
        return new Uid(PermissionSetInheritance.dnGetpermissionSetInheritanceId(this));
    }

    public PermissionSet getPermissionSet() {
        return PermissionSetInheritance.dnGetpermissionSet(this);
    }

    public void setPermissionSet(PermissionSet permissionSet) {
        if (!Util.equal((Object)((Object)PermissionSetInheritance.dnGetpermissionSet(this)), (Object)((Object)permissionSet))) {
            PermissionSetInheritance.dnSetpermissionSet(this, permissionSet);
        }
    }

    public long getLocalRevision() {
        return PermissionSetInheritance.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)PermissionSetInheritance.dnGetlocalRevision(this), (long)localRevision)) {
            PermissionSetInheritance.dnSetlocalRevision(this, localRevision);
        }
    }

    public Date getRevoked() {
        return PermissionSetInheritance.dnGetrevoked(this);
    }

    public void setRevoked(Date revoked) {
        if (!Util.equal((Object)PermissionSetInheritance.dnGetrevoked(this), (Object)revoked)) {
            PermissionSetInheritance.dnSetrevoked(this, revoked);
        }
    }

    public Date getValidFrom() {
        return PermissionSetInheritance.dnGetvalidFrom(this);
    }

    public void setValidFrom(Date validFrom) {
        if (!Util.equal((Object)PermissionSetInheritance.dnGetvalidFrom(this), (Object)validFrom)) {
            PermissionSetInheritance.dnSetvalidFrom(this, validFrom);
        }
    }

    public Date getValidTo() {
        return PermissionSetInheritance.dnGetvalidTo(this);
    }

    public void setValidTo(Date validTo) {
        if (!Util.equal((Object)PermissionSetInheritance.dnGetvalidTo(this), (Object)validTo)) {
            PermissionSetInheritance.dnSetvalidTo(this, validTo);
        }
    }

    public String getSignedDataType() {
        return "PermissionSetInheritance";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[9];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getPermissionSetInheritanceId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((Uid)PermissionSetInheritance.dnGetpermissionSet(this).getCryptoRepoFile().getCryptoRepoFileId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((Date)PermissionSetInheritance.dnGetvalidFrom(this));
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource((Date)PermissionSetInheritance.dnGetrevoked(this));
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[7] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[8] = InputStreamSource.Helper.createInputStreamSource((Date)PermissionSetInheritance.dnGetvalidTo(this));
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return PermissionSetInheritance.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)PermissionSetInheritance.dnGetsignature(this), (Object)signature)) {
            PermissionSetInheritance.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    @IgnoreDatabaseMigraterComparison
    public Uid getCryptoRepoFileIdControllingPermissions() {
        Objects.requireNonNull(PermissionSetInheritance.dnGetpermissionSet(this), "permissionSet");
        return Objects.requireNonNull(PermissionSetInheritance.dnGetpermissionSet(this).getCryptoRepoFileIdControllingPermissions(), "permissionSet.cryptoRepoFileIdControllingPermissions");
    }

    @IgnoreDatabaseMigraterComparison
    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.grant;
    }

    static {
        EnhancementHelper.registerClass((Class)PermissionSetInheritance.___dn$loadClass("org.subshare.local.persistence.PermissionSetInheritance"), (Persistable)new PermissionSetInheritance());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        PermissionSetInheritance result = new PermissionSetInheritance();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        PermissionSetInheritance result = new PermissionSetInheritance();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 1: {
                this.permissionSet = (PermissionSet)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 2: {
                this.permissionSetInheritanceId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.revoked = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 5: {
                this.validFrom = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.validTo = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.permissionSet);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.permissionSetInheritanceId);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.revoked);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.validFrom);
                break;
            }
            case 6: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.validTo);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(PermissionSetInheritance obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 1: {
                this.permissionSet = obj.permissionSet;
                break;
            }
            case 2: {
                this.permissionSetInheritanceId = obj.permissionSetInheritanceId;
                break;
            }
            case 3: {
                this.revoked = obj.revoked;
                break;
            }
            case 4: {
                this.signature = obj.signature;
                break;
            }
            case 5: {
                this.validFrom = obj.validFrom;
                break;
            }
            case 6: {
                this.validTo = obj.validTo;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof PermissionSetInheritance)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.PermissionSetInheritance");
        }
        PermissionSetInheritance other = (PermissionSetInheritance)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"localRevision", "permissionSet", "permissionSetInheritanceId", "revoked", "signature", "validFrom", "validTo"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 7 + Entity.dnGetManagedFieldCount();
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static long dnGetlocalRevision(PermissionSetInheritance objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(PermissionSetInheritance objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static PermissionSet dnGetpermissionSet(PermissionSetInheritance objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (PermissionSet)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.permissionSet));
        }
        return objPC.permissionSet;
    }

    private static void dnSetpermissionSet(PermissionSetInheritance objPC, PermissionSet val) {
        if (objPC.dnStateManager == null) {
            objPC.permissionSet = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.permissionSet, (Object)val);
        }
    }

    private static String dnGetpermissionSetInheritanceId(PermissionSetInheritance objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.permissionSetInheritanceId);
        }
        return objPC.permissionSetInheritanceId;
    }

    private static void dnSetpermissionSetInheritanceId(PermissionSetInheritance objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.permissionSetInheritanceId, val);
        } else {
            objPC.permissionSetInheritanceId = val;
        }
    }

    private static Date dnGetrevoked(PermissionSetInheritance objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.revoked);
        }
        return objPC.revoked;
    }

    private static void dnSetrevoked(PermissionSetInheritance objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3 + dnInheritedFieldCount, (Object)objPC.revoked, (Object)val);
        } else {
            objPC.revoked = val;
        }
    }

    private static SignatureImpl dnGetsignature(PermissionSetInheritance objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(PermissionSetInheritance objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }

    private static Date dnGetvalidFrom(PermissionSetInheritance objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.validFrom);
        }
        return objPC.validFrom;
    }

    private static void dnSetvalidFrom(PermissionSetInheritance objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.validFrom, (Object)val);
        } else {
            objPC.validFrom = val;
        }
    }

    private static Date dnGetvalidTo(PermissionSetInheritance objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 6 + dnInheritedFieldCount, (Object)objPC.validTo);
        }
        return objPC.validTo;
    }

    private static void dnSetvalidTo(PermissionSetInheritance objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 6 + dnInheritedFieldCount, (Object)objPC.validTo, (Object)val);
        } else {
            objPC.validTo = val;
        }
    }
}

