/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.subshare.crypto.MACCalculator;
import org.subshare.crypto.MACCalculatorFactory;

public abstract class AbstractMACCalculatorFactory
implements MACCalculatorFactory {
    private String algorithmName;

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public void setAlgorithmName(String algorithmName) {
        if (this.algorithmName != null && !this.algorithmName.equals(algorithmName)) {
            throw new IllegalStateException("this.algorithmName is already assigned! Cannot modify!");
        }
        if (algorithmName == null) {
            throw new IllegalArgumentException("algorithmName == null");
        }
        this.algorithmName = algorithmName;
    }

    @Override
    public MACCalculator createMACCalculator(boolean initWithDefaults) {
        MACCalculator macCalculator = this._createMACCalculator();
        if (initWithDefaults) {
            SecureRandom random = new SecureRandom();
            byte[] key = new byte[macCalculator.getKeySize()];
            random.nextBytes(key);
            if (macCalculator.getIVSize() > 0) {
                byte[] iv = new byte[macCalculator.getIVSize()];
                random.nextBytes(iv);
                macCalculator.init((CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
            } else {
                macCalculator.init((CipherParameters)new KeyParameter(key));
            }
        }
        macCalculator.setAlgorithmName(this.getAlgorithmName());
        return macCalculator;
    }

    protected abstract MACCalculator _createMACCalculator();
}

