/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.internal;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.wot.Config;
import org.bouncycastle.openpgp.wot.DateUtil;
import org.bouncycastle.openpgp.wot.OwnerTrust;
import org.bouncycastle.openpgp.wot.PgpFile;
import org.bouncycastle.openpgp.wot.TrustConst;
import org.bouncycastle.openpgp.wot.TrustDb;
import org.bouncycastle.openpgp.wot.TrustModel;
import org.bouncycastle.openpgp.wot.Validity;
import org.bouncycastle.openpgp.wot.internal.PgpKeyTrust;
import org.bouncycastle.openpgp.wot.internal.PgpUserIdTrust;
import org.bouncycastle.openpgp.wot.internal.TrustDbIo;
import org.bouncycastle.openpgp.wot.internal.TrustRecord;
import org.bouncycastle.openpgp.wot.internal.TrustRecordType;
import org.bouncycastle.openpgp.wot.key.PgpKey;
import org.bouncycastle.openpgp.wot.key.PgpKeyFingerprint;
import org.bouncycastle.openpgp.wot.key.PgpKeyId;
import org.bouncycastle.openpgp.wot.key.PgpKeyRegistry;
import org.bouncycastle.openpgp.wot.key.PgpUserId;
import org.bouncycastle.openpgp.wot.key.PgpUserIdNameHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustDbImpl
implements TrustDb,
TrustConst {
    private static final Logger logger = LoggerFactory.getLogger(TrustDbImpl.class);
    private final PgpKeyRegistry pgpKeyRegistry;
    private final Object mutex;
    private final TrustDbIo trustDbIo;
    private long startTime;
    private long nextExpire;
    private Map<PgpKeyFingerprint, PgpKeyTrust> fingerprint2PgpKeyTrust;
    private Set<PgpKeyFingerprint> klist;
    private Set<PgpKeyFingerprint> fullTrust;
    private DateFormat dateFormatIso8601WithTime;

    public TrustDbImpl(PgpFile file, PgpKeyRegistry pgpKeyRegistry) {
        Objects.requireNonNull(file, "file");
        this.pgpKeyRegistry = Objects.requireNonNull(pgpKeyRegistry, "pgpKeyRegistry");
        this.mutex = pgpKeyRegistry.getPubringFile().getPgpId();
        this.trustDbIo = new TrustDbIo(file, this.mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mutex;
        synchronized (object) {
            this.trustDbIo.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateFormat getDateFormatIso8601WithTime() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.dateFormatIso8601WithTime == null) {
                this.dateFormatIso8601WithTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            }
            return this.dateFormatIso8601WithTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PgpKeyTrust getPgpKeyTrust(PgpKey pgpKey) {
        Object object = this.mutex;
        synchronized (object) {
            PgpKeyTrust pgpKeyTrust = this.fingerprint2PgpKeyTrust.get(pgpKey.getPgpKeyFingerprint());
            if (pgpKeyTrust == null) {
                pgpKeyTrust = new PgpKeyTrust(pgpKey);
                this.fingerprint2PgpKeyTrust.put(pgpKeyTrust.getPgpKeyFingerprint(), pgpKeyTrust);
            }
            return pgpKeyTrust;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetTrustRecords() {
        Object object = this.mutex;
        synchronized (object) {
            TrustRecord record;
            long recordNum = 0L;
            int count = 0;
            int nreset = 0;
            while ((record = this.trustDbIo.getTrustRecord(++recordNum)) != null) {
                TrustRecord.Valid valid;
                if (record.getType() == TrustRecordType.TRUST) {
                    TrustRecord.Trust trust = (TrustRecord.Trust)record;
                    ++count;
                    if (trust.getMinOwnerTrust() == 0) continue;
                    trust.setMinOwnerTrust((short)0);
                    this.trustDbIo.putTrustRecord(record);
                    continue;
                }
                if (record.getType() != TrustRecordType.VALID || ((valid = (TrustRecord.Valid)record).getValidity() & 0xF) == 0 && valid.getMarginalCount() == 0 && valid.getFullCount() == 0) continue;
                valid.setValidity((short)(valid.getValidity() & 0xFFFFFFF0));
                valid.setMarginalCount((short)0);
                valid.setFullCount((short)0);
                ++nreset;
                this.trustDbIo.putTrustRecord(record);
            }
            logger.debug("resetTrustRecords: {} keys processed ({} validity counts cleared)", (Object)count, (Object)nreset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OwnerTrust getOwnerTrust(PgpKey pgpKey) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(pgpKey, "pgpKey");
            if (pgpKey.getMasterKey() != null) {
                pgpKey = pgpKey.getMasterKey();
            }
            return this.getOwnerTrust(pgpKey.getPublicKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOwnerTrust(PgpKey pgpKey, OwnerTrust ownerTrust) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(pgpKey, "pgpKey");
            Objects.requireNonNull(ownerTrust, "ownerTrust");
            if (pgpKey.getMasterKey() != null) {
                pgpKey = pgpKey.getMasterKey();
            }
            this.setOwnerTrust(pgpKey.getPublicKey(), ownerTrust);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OwnerTrust getOwnerTrust(PGPPublicKey publicKey) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            TrustRecord.Trust trust = this.getTrustByPublicKey(publicKey);
            if (trust == null) {
                return null;
            }
            return OwnerTrust.fromNumericValue(trust.getOwnerTrust() & 0xF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOwnerTrust(PGPPublicKey publicKey, OwnerTrust ownerTrust) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            Objects.requireNonNull(ownerTrust, "ownerTrust");
            TrustRecord.Trust trust = this.getTrustByPublicKey(publicKey);
            if (trust == null) {
                trust = new TrustRecord.Trust();
                trust.setFingerprint(publicKey.getFingerprint());
            }
            int ownerTrustAdditionalFlags = trust.getOwnerTrust() & 0xFFFFFFF0;
            trust.setOwnerTrust((short)(ownerTrust.getNumericValue() | ownerTrustAdditionalFlags));
            this.trustDbIo.putTrustRecord(trust);
            this.markTrustDbStale();
            this.trustDbIo.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TrustRecord.Trust getTrustByPublicKey(PGPPublicKey publicKey) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            TrustRecord.Trust trust = this.trustDbIo.getTrustByPublicKey(publicKey);
            return trust;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getValidityRaw(PGPPublicKey publicKey) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            return this._getValidity(publicKey, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getValidityRaw(PGPPublicKey publicKey, PgpUserIdNameHash pgpUserIdNameHash) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            Objects.requireNonNull(pgpUserIdNameHash, "pgpUserIdNameHash");
            return this._getValidity(publicKey, pgpUserIdNameHash, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Validity getValidity(PgpKey pgpKey) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(pgpKey, "pgpKey");
            return this.getValidity(pgpKey.getPublicKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Validity getValidity(PgpUserId pgpUserId) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(pgpUserId, "pgpUserId");
            return this.getValidity(pgpUserId.getPgpKey().getPublicKey(), pgpUserId.getNameHash());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Validity getValidity(PGPPublicKey publicKey) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            int numericValue = this._getValidity(publicKey, null, false);
            return Validity.fromNumericValue(numericValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Validity getValidity(PGPPublicKey publicKey, PgpUserIdNameHash pgpUserIdNameHash) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            Objects.requireNonNull(pgpUserIdNameHash, "pgpUserIdNameHash");
            int numericValue = this._getValidity(publicKey, pgpUserIdNameHash, false);
            return Validity.fromNumericValue(numericValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _getValidity(PGPPublicKey publicKey, PgpUserIdNameHash pgpUserIdNameHash, boolean withFlags) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            TrustRecord.Trust trust = this.getTrustByPublicKey(publicKey);
            if (trust == null) {
                return 0;
            }
            long recordNum = trust.getValidList();
            int validity = 0;
            int flags = 0;
            while (recordNum != 0L) {
                TrustRecord.Valid valid = this.trustDbIo.getTrustRecord(recordNum, TrustRecord.Valid.class);
                Objects.requireNonNull(valid, "valid");
                if (pgpUserIdNameHash != null) {
                    if (pgpUserIdNameHash.equals(valid.getNameHash())) {
                        validity = valid.getValidity() & 0xF;
                        flags = valid.getValidity() & 0xFFFFFFF0;
                        break;
                    }
                } else {
                    validity = Math.max(validity, valid.getValidity() & 0xF);
                    flags |= valid.getValidity() & 0xFFFFFFF0;
                }
                recordNum = valid.getNext();
            }
            if (withFlags) {
                validity |= flags;
                if ((trust.getOwnerTrust() & 0x80) != 0) {
                    validity |= 0x80;
                }
                if (publicKey.isRevoked()) {
                    validity |= 0x20;
                }
                if (this.isTrustDbStale()) {
                    validity |= 0x100;
                }
            }
            return validity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateValidity(PgpUserId pgpUserId, int depth, int validity, int fullCount, int marginalCount) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(pgpUserId, "pgpUserId");
            TrustDbImpl.assertNonNegativeShort("depth", depth);
            TrustDbImpl.assertNonNegativeShort("validity", validity);
            TrustDbImpl.assertNonNegativeShort("fullCount", fullCount);
            TrustDbImpl.assertNonNegativeShort("marginalCount", marginalCount);
            TrustRecord.Trust trust = this.getTrustByPublicKey(pgpUserId.getPgpKey().getPublicKey());
            if (trust == null) {
                trust = new TrustRecord.Trust();
                trust.setFingerprint(pgpUserId.getPgpKey().getPgpKeyFingerprint().getBytes());
                this.trustDbIo.putTrustRecord(trust);
            }
            TrustRecord.Valid valid = null;
            byte[] pgpUserIdNameHashBytes = pgpUserId.getNameHash().getBytes();
            long recordNum = trust.getValidList();
            while (recordNum != 0L && !Arrays.equals((valid = this.trustDbIo.getTrustRecord(recordNum, TrustRecord.Valid.class)).getNameHash(), pgpUserIdNameHashBytes)) {
                recordNum = valid.getNext();
            }
            if (recordNum == 0L) {
                valid = new TrustRecord.Valid();
                valid.setNameHash(pgpUserIdNameHashBytes);
                valid.setNext(trust.getValidList());
                this.trustDbIo.putTrustRecord(valid);
                trust.setValidList(valid.getRecordNum());
            }
            valid.setValidity((short)validity);
            valid.setFullCount((short)fullCount);
            valid.setMarginalCount((short)marginalCount);
            trust.setDepth((short)depth);
            this.trustDbIo.putTrustRecord(trust);
            this.trustDbIo.putTrustRecord(valid);
        }
    }

    private static void assertNonNegativeShort(String name, int value) {
        Objects.requireNonNull(name, "name");
        if (value < 0) {
            throw new IllegalArgumentException(name + " < 0");
        }
        if (value > Short.MAX_VALUE) {
            throw new IllegalArgumentException(name + " > Short.MAX_VALUE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUltimatelyTrustedKeysFromAvailableSecretKeys(boolean onlyIfMissing) {
        Object object = this.mutex;
        synchronized (object) {
            for (PgpKey masterKey : this.pgpKeyRegistry.getMasterKeys()) {
                TrustRecord.Trust trust;
                if (masterKey.getSecretKey() == null || (trust = this.trustDbIo.getTrustByPublicKey(masterKey.getPublicKey())) != null && trust.getOwnerTrust() != 0 && onlyIfMissing) continue;
                if (trust == null) {
                    trust = new TrustRecord.Trust();
                    trust.setFingerprint(masterKey.getPgpKeyFingerprint().getBytes());
                }
                trust.setDepth((short)0);
                trust.setOwnerTrust((short)6);
                this.trustDbIo.putTrustRecord(trust);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<PgpKeyFingerprint> getUltimatelyTrustedKeyFingerprints() {
        Object object = this.mutex;
        synchronized (object) {
            TrustRecord record;
            HashSet<PgpKeyFingerprint> result = new HashSet<PgpKeyFingerprint>();
            long recordNum = 0L;
            while ((record = this.trustDbIo.getTrustRecord(++recordNum)) != null) {
                TrustRecord.Trust trust;
                if (record.getType() != TrustRecordType.TRUST || ((trust = (TrustRecord.Trust)record).getOwnerTrust() & 0xF) != 6) continue;
                result.add(new PgpKeyFingerprint(trust.getFingerprint()));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpired(PGPPublicKey publicKey) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            Date creationTime = publicKey.getCreationTime();
            long validSeconds = publicKey.getValidSeconds();
            if (validSeconds != 0L) {
                long validUntilTimestamp = creationTime.getTime() + validSeconds * 1000L;
                boolean bl = validUntilTimestamp < System.currentTimeMillis();
                return bl;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisabled(PgpKey pgpKey) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(pgpKey, "pgpKey");
            if (pgpKey.getMasterKey() != null) {
                pgpKey = pgpKey.getMasterKey();
            }
            return this.isDisabled(pgpKey.getPublicKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisabled(PgpKey pgpKey, boolean disabled) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(pgpKey, "pgpKey");
            if (pgpKey.getMasterKey() != null) {
                pgpKey = pgpKey.getMasterKey();
            }
            this.setDisabled(pgpKey.getPublicKey(), disabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisabled(PGPPublicKey publicKey) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            TrustRecord.Trust trust = this.trustDbIo.getTrustByFingerprint(publicKey.getFingerprint());
            if (trust == null) {
                return false;
            }
            return (trust.getOwnerTrust() & 0x80) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisabled(PGPPublicKey publicKey, boolean disabled) {
        Object object = this.mutex;
        synchronized (object) {
            Objects.requireNonNull(publicKey, "publicKey");
            TrustRecord.Trust trust = this.trustDbIo.getTrustByFingerprint(publicKey.getFingerprint());
            if (trust == null) {
                trust = new TrustRecord.Trust();
                trust.setFingerprint(publicKey.getFingerprint());
            }
            int ownerTrust = trust.getOwnerTrust();
            ownerTrust = disabled ? (ownerTrust |= 0x80) : (ownerTrust &= 0xFFFFFF7F);
            trust.setOwnerTrust((short)ownerTrust);
            this.trustDbIo.putTrustRecord(trust);
            this.trustDbIo.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTrustDbStale() {
        Object object = this.mutex;
        synchronized (object) {
            Config config = Config.getInstance();
            TrustRecord.Version version = this.trustDbIo.getTrustRecord(0L, TrustRecord.Version.class);
            Objects.requireNonNull(version, "version");
            if (config.getTrustModel() != version.getTrustModel()) {
                TrustModel versionTrustModel;
                TrustModel configTrustModel;
                try {
                    configTrustModel = TrustModel.fromNumericId(config.getTrustModel());
                }
                catch (IllegalArgumentException x) {
                    configTrustModel = null;
                }
                try {
                    versionTrustModel = TrustModel.fromNumericId(version.getTrustModel());
                }
                catch (IllegalArgumentException x) {
                    versionTrustModel = null;
                }
                logger.debug("isTrustDbStale: stale=true config.trustModel={} ({}) trustDb.trustModel={} ({})", new Object[]{config.getTrustModel(), configTrustModel, version.getTrustModel(), versionTrustModel});
                return true;
            }
            if (config.getCompletesNeeded() != version.getCompletesNeeded()) {
                logger.debug("isTrustDbStale: stale=true config.completesNeeded={} trustDb.completesNeeded={}", (Object)config.getCompletesNeeded(), (Object)version.getCompletesNeeded());
                return true;
            }
            if (config.getMarginalsNeeded() != version.getMarginalsNeeded()) {
                logger.debug("isTrustDbStale: stale=true config.marginalsNeeded={} trustDb.marginalsNeeded={}", (Object)config.getMarginalsNeeded(), (Object)version.getMarginalsNeeded());
                return true;
            }
            if (config.getMaxCertDepth() != version.getCertDepth()) {
                logger.debug("isTrustDbStale: stale=true config.maxCertDepth={} trustDb.maxCertDepth={}", (Object)config.getMaxCertDepth(), (Object)version.getCertDepth());
                return true;
            }
            Date now = DateUtil.now();
            if (version.getNextCheck().before(now)) {
                logger.debug("isTrustDbStale: stale=true nextCheck={} now={}", (Object)this.getDateFormatIso8601WithTime().format(version.getNextCheck()), (Object)this.getDateFormatIso8601WithTime().format(now));
                return true;
            }
            logger.trace("isTrustDbStale: stale=false");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markTrustDbStale() {
        Object object = this.mutex;
        synchronized (object) {
            TrustRecord.Version version = this.trustDbIo.getTrustRecord(0L, TrustRecord.Version.class);
            Objects.requireNonNull(version, "version");
            version.setNextCheck(new Date(0L));
            this.trustDbIo.putTrustRecord(version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTrustDbIfNeeded() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isTrustDbStale()) {
                this.updateTrustDb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTrustDb() {
        Object object = this.mutex;
        synchronized (object) {
            Config config = Config.getInstance();
            try {
                this.fingerprint2PgpKeyTrust = new HashMap<PgpKeyFingerprint, PgpKeyTrust>();
                this.fullTrust = new HashSet<PgpKeyFingerprint>();
                this.startTime = System.currentTimeMillis() / 1000L;
                this.nextExpire = Long.MAX_VALUE;
                this.resetTrustRecords();
                Set<PgpKeyFingerprint> ultimatelyTrustedKeyFingerprints = this.getUltimatelyTrustedKeyFingerprints();
                if (ultimatelyTrustedKeyFingerprints.isEmpty()) {
                    logger.warn("updateTrustDb: There are no ultimately trusted keys!");
                    return;
                }
                for (PgpKeyFingerprint utkFpr : ultimatelyTrustedKeyFingerprints) {
                    PgpKey utk = this.pgpKeyRegistry.getPgpKey(utkFpr);
                    if (utk == null) {
                        logger.warn("public key of ultimately trusted key '{}' not found!", (Object)utkFpr.toHumanString());
                        continue;
                    }
                    this.fullTrust.add(utkFpr);
                    for (PgpUserId pgpUserId : utk.getPgpUserIds()) {
                        this.updateValidity(pgpUserId, 0, 6, 0, 0);
                    }
                    long expireDate = this.getExpireTimestamp(utk.getPublicKey());
                    if (expireDate < this.startTime || expireDate >= this.nextExpire) continue;
                    this.nextExpire = expireDate;
                }
                this.klist = ultimatelyTrustedKeyFingerprints;
                for (int depth = 0; depth < config.getMaxCertDepth(); ++depth) {
                    List<PgpKey> validatedKeys = this.validateKeyList();
                    this.klist = new HashSet<PgpKeyFingerprint>();
                    for (PgpKey pgpKey : validatedKeys) {
                        PgpKeyTrust pgpKeyTrust = this.getPgpKeyTrust(pgpKey);
                        this.klist.add(pgpKey.getPgpKeyFingerprint());
                        for (PgpUserIdTrust pgpUserIdTrust : pgpKeyTrust.getPgpUserIdTrusts()) {
                            PgpUserId pgpUserId = pgpUserIdTrust.getPgpUserId();
                            int validity = pgpUserIdTrust.getValidity();
                            this.updateValidity(pgpUserId, depth, validity, pgpUserIdTrust.getFullCount(), pgpUserIdTrust.getMarginalCount());
                            if (validity < 5) continue;
                            this.fullTrust.add(pgpUserIdTrust.getPgpUserId().getPgpKey().getPgpKeyFingerprint());
                        }
                        long expireDate = this.getExpireTimestamp(pgpKey.getPublicKey());
                        if (expireDate < this.startTime || expireDate >= this.nextExpire) continue;
                        this.nextExpire = expireDate;
                    }
                    logger.debug("updateTrustDb: depth={} keys={}", (Object)depth, (Object)validatedKeys.size());
                }
                Date nextExpireDate = new Date(this.nextExpire * 1000L);
                this.trustDbIo.updateVersionRecord(nextExpireDate);
                this.trustDbIo.flush();
                logger.info("updateTrustDb: Next trust-db expiration date: {}", (Object)this.getDateFormatIso8601WithTime().format(nextExpireDate));
            }
            finally {
                this.fingerprint2PgpKeyTrust = null;
                this.klist = null;
                this.fullTrust = null;
            }
        }
    }

    private long getExpireTimestamp(PGPPublicKey pk) {
        long validSeconds = pk.getValidSeconds();
        if (validSeconds == 0L) {
            return Long.MAX_VALUE;
        }
        long result = pk.getCreationTime().getTime() / 1000L + validSeconds;
        return result;
    }

    private List<PgpKey> validateKeyList() {
        ArrayList<PgpKey> result = new ArrayList<PgpKey>();
        HashSet<PgpKeyFingerprint> signedPgpKeyFingerprints = new HashSet<PgpKeyFingerprint>();
        for (PgpKeyFingerprint signingPgpKeyFingerprint : this.klist) {
            signedPgpKeyFingerprints.addAll(this.pgpKeyRegistry.getPgpKeyFingerprintsCertifiedBy(signingPgpKeyFingerprint));
        }
        signedPgpKeyFingerprints.removeAll(this.fullTrust);
        for (PgpKeyFingerprint pgpKeyFingerprint : signedPgpKeyFingerprints) {
            PgpKey pgpKey = this.pgpKeyRegistry.getPgpKey(pgpKeyFingerprint);
            if (pgpKey == null) {
                logger.warn("key disappeared: fingerprint='{}'", (Object)pgpKeyFingerprint);
                continue;
            }
            result.add(pgpKey);
            this.validateKey(pgpKey);
        }
        return result;
    }

    private void validateKey(PgpKey pgpKey) {
        Objects.requireNonNull(pgpKey, "pgpKey");
        logger.debug("validateKey: {}", (Object)pgpKey);
        Config config = Config.getInstance();
        PgpKeyTrust pgpKeyTrust = this.getPgpKeyTrust(pgpKey);
        boolean expired = this.isExpired(pgpKey.getPublicKey());
        boolean revoked = pgpKey.getPublicKey().isRevoked();
        for (PgpUserId pgpUserId : pgpKey.getPgpUserIds()) {
            PgpUserIdTrust pgpUserIdTrust = pgpKeyTrust.getPgpUserIdTrust(pgpUserId);
            pgpUserIdTrust.setValidity(0);
            pgpUserIdTrust.setUltimateCount(0);
            pgpUserIdTrust.setFullCount(0);
            pgpUserIdTrust.setMarginalCount(0);
            if (expired || revoked) continue;
            for (PGPSignature certification : this.pgpKeyRegistry.getCertifications(pgpUserId)) {
                int signingValidity;
                PgpKey signingKey;
                if (certification.getSignatureType() != 16 && certification.getSignatureType() != 18 && certification.getSignatureType() != 19 || (signingKey = this.pgpKeyRegistry.getPgpKey(new PgpKeyId(certification.getKeyID()))) == null) continue;
                OwnerTrust signingOwnerTrust = this.getOwnerTrust(signingKey.getPublicKey());
                if (signingKey.getPgpKeyId().equals(pgpKey.getPgpKeyId()) && signingOwnerTrust != OwnerTrust.ULTIMATE || (signingValidity = this.getValidityRaw(signingKey.getPublicKey()) & 0xF) <= 4) continue;
                switch (signingOwnerTrust) {
                    case ULTIMATE: {
                        pgpUserIdTrust.incUltimateCount();
                        break;
                    }
                    case FULL: {
                        pgpUserIdTrust.incFullCount();
                        break;
                    }
                    case MARGINAL: {
                        pgpUserIdTrust.incMarginalCount();
                        break;
                    }
                }
            }
            if (pgpUserIdTrust.getUltimateCount() >= 1) {
                pgpUserIdTrust.setValidity(5);
                continue;
            }
            if (pgpUserIdTrust.getFullCount() >= config.getCompletesNeeded()) {
                pgpUserIdTrust.setValidity(5);
                continue;
            }
            if (pgpUserIdTrust.getFullCount() + pgpUserIdTrust.getMarginalCount() >= config.getMarginalsNeeded()) {
                pgpUserIdTrust.setValidity(5);
                continue;
            }
            if (pgpUserIdTrust.getFullCount() < 1 && pgpUserIdTrust.getMarginalCount() < 1) continue;
            pgpUserIdTrust.setValidity(4);
        }
    }
}

