/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.DaoProvider;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.util.DebugUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.PersistencePropertiesProvider;
import co.codewizards.cloudstore.local.db.Column;
import co.codewizards.cloudstore.local.db.DatabaseAdapter;
import co.codewizards.cloudstore.local.db.DatabaseAdapterFactory;
import co.codewizards.cloudstore.local.db.DatabaseAdapterFactoryRegistry;
import co.codewizards.cloudstore.local.db.IgnoreDatabaseMigraterComparison;
import co.codewizards.cloudstore.local.db.Table;
import co.codewizards.cloudstore.local.persistence.CloudStorePersistenceCapableClassesProvider;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Directory;
import co.codewizards.cloudstore.local.persistence.Entity;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.NormalFileDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.jdo.FetchPlan;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMigrater
implements DaoProvider {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseMigrater.class);
    public static final String DBMIGRATE_TRIGGER_FILE_NAME = "dbmigrate.deleteToRun";
    public static final String DBMIGRATE_STATUS_FILE_NAME = "dbmigrate.status.properties";
    public static final String DBMIGRATE_TARGET_DIR_NAME = "dbmigrate.target.tmp";
    public static final String STATUS_SOURCE_DB_ADAPTER_NAME = "sourceDatabaseAdapterName";
    public static final String STATUS_TARGET_DB_ADAPTER_NAME = "targetDatabaseAdapterName";
    public static final String STATUS_TARGET_DB_CREATED = "targetDatabaseCreated";
    public static final String STATUS_MIGRATION_COMPLETE = "MIGRATION_COMPLETE";
    public static final String STATUS_TARGET_TABLE_IDENTITY_COLUMN_PASSIVATED_FORMAT = "targetTable[%s].identityColumnPassivated";
    public static final String STATUS_TARGET_TABLE_IDENTITY_COLUMN_ACTIVATED_FORMAT = "targetTable[%s].identityColumnActivated";
    public static final String STATUS_TABLE_DATA_COPIED_FORMAT = "table[%s].dataCopied";
    public static final String STATUS_COMPARE_PERSISTENT_OBECTS_MIN_ID_FORMAT = "comparePersistentObjects[%s].minId";
    public static final String STATUS_COMPARE_PERSISTENT_OBECTS_MAX_ID_FORMAT = "comparePersistentObjects[%s].maxId";
    public static final String STATUS_COMPARE_PERSISTENT_OBECTS_FROM_ID_INCL_FORMAT = "comparePersistentObjects[%s].fromIdIncl";
    public static final String STATUS_COMPARE_PERSISTENT_OBECTS_OBJECT_COUNT_FORMAT = "comparePersistentObjects[%s].objectCount";
    protected final File localRoot;
    protected final File metaDir;
    protected final File lockFile;
    protected final File targetLocalRoot;
    protected final File targetMetaDir;
    protected final UUID repositoryId;
    protected Properties status = new Properties();
    protected DatabaseAdapterFactory sourceDbAdapterFactory;
    protected DatabaseAdapterFactory targetDbAdapterFactory;
    protected DatabaseAdapter sourceDbAdapter;
    protected DatabaseAdapter targetDbAdapter;
    protected PersistenceManagerFactory sourcePmf;
    protected PersistenceManagerFactory targetPmf;
    protected PersistenceManager sourcePm;
    protected PersistenceManager targetPm;
    protected Connection sourceConnection;
    protected Connection targetConnection;
    private final Map<Class<?>, Object> daoClass2Dao = new HashMap();
    private static Map<Integer, String> jdbcTypeIntToString;
    private Map<Class<?>, List<Method>> objectClass2Getters = new HashMap();

    protected DatabaseMigrater(File localRoot) {
        this.localRoot = Objects.requireNonNull(localRoot, "localRoot");
        this.metaDir = this.localRoot.createFile(new String[]{LocalRepoManager.META_DIR_NAME});
        this.lockFile = this.metaDir.createFile(new String[]{LocalRepoManager.REPOSITORY_LOCK_FILE_NAME});
        this.targetLocalRoot = this.metaDir.createFile(new String[]{DBMIGRATE_TARGET_DIR_NAME});
        this.targetMetaDir = this.targetLocalRoot.createFile(new String[]{LocalRepoManager.META_DIR_NAME});
        this.repositoryId = this.readRepositoryIdFromRepositoryPropertiesFile();
    }

    public static DatabaseMigrater create(File localRoot) {
        Objects.requireNonNull(localRoot, "localRoot");
        return (DatabaseMigrater)ObjectFactoryUtil.createObject(DatabaseMigrater.class, (Object[])new Object[]{localRoot});
    }

    private UUID readRepositoryIdFromRepositoryPropertiesFile() {
        File repositoryPropertiesFile = OioFileFactory.createFile((File)this.metaDir, (String[])new String[]{LocalRepoManager.REPOSITORY_PROPERTIES_FILE_NAME});
        if (!repositoryPropertiesFile.isFile()) {
            return null;
        }
        try {
            Properties repositoryProperties = new Properties();
            try (InputStream in = StreamUtil.castStream((IInputStream)repositoryPropertiesFile.createInputStream());){
                repositoryProperties.load(in);
            }
            String repositoryIdStr = repositoryProperties.getProperty("repository.id");
            if (StringUtil.isEmpty((String)repositoryIdStr)) {
                throw new IllegalStateException("repositoryProperties.getProperty(PROP_REPOSITORY_ID) is empty!");
            }
            UUID repositoryId = UUID.fromString(repositoryIdStr);
            return repositoryId;
        }
        catch (Exception x) {
            throw new RuntimeException("Reading readRepositoryId from '" + repositoryPropertiesFile.getAbsolutePath() + "' failed: " + x, x);
        }
    }

    public void deleteTriggerFile() {
        File triggerFile = this.getTriggerFile();
        if (!triggerFile.exists()) {
            logger.info("deleteTriggerFile: Trigger-file '{}' does not exist => cannot delete.", (Object)triggerFile.getAbsolutePath());
            return;
        }
        triggerFile.delete();
        if (triggerFile.exists()) {
            throw new IllegalStateException(String.format("Trigger-file '%s' could not be deleted (it still exists)!", triggerFile.getAbsolutePath()));
        }
        logger.info("deleteTriggerFile: Trigger-file '{}' successfully deleted.", (Object)triggerFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateIfNeeded() {
        LockFile lf = LockFileFactory.getInstance().acquire(this.lockFile, 3000L);
        try {
            Lock lock = lf.getLock();
            try {
                if (!lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Cannot lock within timeout!");
                }
            }
            catch (InterruptedException x) {
                logger.warn("migrateIfNeeded: localRoot='" + this.localRoot + "': " + x, (Throwable)x);
                if (lf != null) {
                    lf.close();
                }
                return;
            }
            try {
                if (!this.isMigrationInProcess()) {
                    logger.info("migrateIfNeeded: localRoot='{}': No migration => return immediately.", (Object)this.localRoot);
                    return;
                }
                try {
                    String targetDbafName;
                    if (LocalRepoManagerFactory.Helper.getInstance().getLocalRoots().contains(this.localRoot)) {
                        throw new IllegalStateException("There is currently a LocalRepoManager open for this localRoot: " + this.localRoot.getPath());
                    }
                    DatabaseAdapterFactoryRegistry databaseAdapterFactoryRegistry = DatabaseAdapterFactoryRegistry.getInstance();
                    this.sourceDbAdapterFactory = databaseAdapterFactoryRegistry.getDatabaseAdapterFactoryOrFail(this.localRoot);
                    this.targetDbAdapterFactory = databaseAdapterFactoryRegistry.getDatabaseAdapterFactoryOrFail();
                    String sourceDbafName = this.sourceDbAdapterFactory.getName();
                    if (sourceDbafName.equals(targetDbafName = this.targetDbAdapterFactory.getName())) {
                        logger.info("migrateIfNeeded: localRoot='{}': sourceDatabaseAdapterName == targetDatabaseAdapterName == '{}' :: Nothing to do!", (Object)this.localRoot, (Object)sourceDbafName);
                    } else {
                        logger.info("migrateIfNeeded: localRoot='{}': sourceDatabaseAdapterName == '{}' != targetDatabaseAdapterName == '{}' :: Starting migration, now!", new Object[]{this.localRoot, sourceDbafName, targetDbafName});
                        this.readStatus();
                        if (this.status.getProperty(STATUS_SOURCE_DB_ADAPTER_NAME) != null && !sourceDbafName.equals(this.status.getProperty(STATUS_SOURCE_DB_ADAPTER_NAME))) {
                            throw new IllegalStateException(String.format("Previously started migration with sourceDatabaseAdapterName = '%s', but current sourceDatabaseAdapterName = '%s'!", this.status.getProperty(STATUS_SOURCE_DB_ADAPTER_NAME), sourceDbafName));
                        }
                        this.status.setProperty(STATUS_SOURCE_DB_ADAPTER_NAME, sourceDbafName);
                        if (this.status.getProperty(STATUS_TARGET_DB_ADAPTER_NAME) != null && !targetDbafName.equals(this.status.getProperty(STATUS_TARGET_DB_ADAPTER_NAME))) {
                            throw new IllegalStateException(String.format("Previously started migration with targetDatabaseAdapterName = '%s', but current targetDatabaseAdapterName = '%s'!", this.status.getProperty(STATUS_TARGET_DB_ADAPTER_NAME), targetDbafName));
                        }
                        this.status.setProperty(STATUS_TARGET_DB_ADAPTER_NAME, targetDbafName);
                        this.writeStatus();
                        if (!Boolean.parseBoolean(this.status.getProperty(STATUS_TARGET_DB_CREATED))) {
                            this.createTargetPersistencePropertiesAndDatabase();
                            this.status.setProperty(STATUS_TARGET_DB_CREATED, Boolean.toString(true));
                            this.writeStatus();
                        }
                        this.createPersistenceManagerFactories();
                        this.closePersistenceManagerFactories();
                        try {
                            this.createJdbcConnections();
                            this.dropTargetForeignKeys();
                            this.copyTableData();
                        }
                        finally {
                            this.closeJdbcConnections();
                        }
                        this.createPersistenceManagerFactories();
                        this.testTargetPersistence();
                        this.closePersistenceManagerFactories();
                        this.moveTargetMetaDirContents();
                        this.status.setProperty(STATUS_MIGRATION_COMPLETE, "MIGRATION_COMPLETE *** *** *** Please delete this file now. *** *** ***");
                        this.writeStatus();
                        logger.info("migrateIfNeeded: localRoot='{}': Migration complete!", (Object)this.localRoot);
                    }
                    this.createTriggerFile();
                }
                catch (RuntimeException x) {
                    throw x;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.closePersistenceManagerFactories();
                }
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            if (lf != null) {
                try {
                    lf.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void moveTargetMetaDirContents() {
        File[] newFiles = this.targetMetaDir.listFiles();
        Objects.requireNonNull(newFiles, "targetMetaDir.listFiles() :: targetMetaDir=" + this.targetMetaDir.getAbsolutePath());
        String backupFileNameSuffix = ".dbmigrate_" + Long.toString(System.currentTimeMillis(), 36) + ".bak";
        for (File newFile : newFiles) {
            File oldFile = this.metaDir.createFile(new String[]{newFile.getName()});
            if (oldFile.exists()) {
                File backupOldFile = oldFile.getParentFile().createFile(new String[]{oldFile.getName() + backupFileNameSuffix});
                if (backupOldFile.exists()) {
                    throw new IllegalStateException("backupOldFile already exists: " + backupOldFile.getAbsolutePath());
                }
                oldFile.renameTo(backupOldFile);
                if (!backupOldFile.exists()) {
                    throw new IllegalStateException(String.format("Renaming '%s' to '%s' failed! Target-file still does not exist!", oldFile.getAbsolutePath(), backupOldFile.getAbsolutePath()));
                }
                if (oldFile.exists()) {
                    throw new IllegalStateException(String.format("Renaming '%s' to '%s' failed! Source-file still exists!", oldFile.getAbsolutePath(), backupOldFile.getAbsolutePath()));
                }
            }
            newFile.renameTo(oldFile);
            if (newFile.exists()) {
                throw new IllegalStateException(String.format("Renaming '%s' to '%s' failed! Source-file still exists!", newFile.getAbsolutePath(), oldFile.getAbsolutePath()));
            }
            if (oldFile.exists()) continue;
            throw new IllegalStateException(String.format("Renaming '%s' to '%s' failed! Target-file still does not exist!", newFile.getAbsolutePath(), oldFile.getAbsolutePath()));
        }
        this.targetMetaDir.delete();
        this.targetLocalRoot.delete();
    }

    protected SortedSet<Table> getTables(Connection connection) throws Exception {
        DatabaseMetaData metaData = Objects.requireNonNull(connection, "connection").getMetaData();
        TreeSet<Table> result = new TreeSet<Table>();
        try (ResultSet rs = metaData.getTables(null, null, null, new String[]{"TABLE"});){
            while (rs.next()) {
                String catalogue = rs.getString("TABLE_CAT");
                String schema = rs.getString("TABLE_SCHEM");
                String name = rs.getString("TABLE_NAME");
                logger.debug("getTables: catalogue='{}' schema='{}' name='{}'", new Object[]{catalogue, schema, name});
                result.add(new Table(catalogue, schema, name));
            }
        }
        return result;
    }

    protected void dropTargetForeignKeys() throws Exception {
        DatabaseMetaData metaData = Objects.requireNonNull(this.targetConnection, "targetConnection").getMetaData();
        SortedSet<Table> tables = this.getTables(this.targetConnection);
        for (Table table : tables) {
            ResultSet rs = metaData.getImportedKeys(table.catalogue, table.schema, table.name);
            try {
                while (rs.next()) {
                    String fkName = rs.getString("FK_NAME");
                    if (fkName == null || fkName.isEmpty()) continue;
                    this.dropForeignKey(this.targetConnection, table, fkName);
                }
            }
            finally {
                if (rs == null) continue;
                rs.close();
            }
        }
    }

    protected void dropForeignKey(Connection connection, Table table, String fkName) throws Exception {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(table, "table");
        Objects.requireNonNull(fkName, "fkName");
        try (Statement statement = connection.createStatement();){
            String sql = String.format("alter table \"%s\" drop constraint \"%s\"", table.name, fkName);
            logger.info("dropForeignKey: Executing: {}", (Object)sql);
            statement.executeUpdate(sql);
        }
    }

    protected void copyTableData() throws Exception {
        SortedSet<Table> sourceTables = this.getTables(this.sourceConnection);
        SortedSet<Table> targetTables = this.getTables(this.targetConnection);
        TreeSet<String> targetTableNames = new TreeSet<String>();
        for (Table table : targetTables) {
            targetTableNames.add(table.name.toUpperCase(Locale.UK));
        }
        TreeSet<String> sourceTableNames = new TreeSet<String>();
        for (Table table : sourceTables) {
            sourceTableNames.add(table.name.toUpperCase(Locale.UK));
        }
        TreeSet treeSet = new TreeSet(sourceTableNames);
        treeSet.removeAll(targetTableNames);
        TreeSet targetTableNamesMissingInSource = new TreeSet(targetTableNames);
        targetTableNamesMissingInSource.removeAll(sourceTableNames);
        if (treeSet.isEmpty()) {
            logger.info("copyTableData: All source-tables exist in the target-DB!");
        } else {
            logger.warn("copyTableData: The following source-tables are missing in the target-DB: {}", treeSet);
        }
        if (targetTableNamesMissingInSource.isEmpty()) {
            logger.info("copyTableData: All target-tables exist in the source-DB!");
        } else {
            logger.warn("copyTableData: The following target-tables are missing in the source-DB: {}", targetTableNamesMissingInSource);
        }
        ArrayList<String> tableNamesToCopy = new ArrayList<String>(sourceTables.size());
        for (Table table : sourceTables) {
            if (!targetTableNames.contains(table.name.toUpperCase(Locale.UK))) continue;
            tableNamesToCopy.add(table.name.toUpperCase(Locale.UK));
        }
        HashMap<String, Table> targetTableName2Table = new HashMap<String, Table>();
        for (Table table : targetTables) {
            targetTableName2Table.put(table.name.toUpperCase(Locale.UK), table);
        }
        Map<Table, List<Column>> map = this.getTable2Columns(this.sourceConnection, sourceTables);
        Map<Table, List<Column>> targetTable2Columns = this.getTable2Columns(this.targetConnection, targetTables);
        int tableIndex = 0;
        for (Table sourceTable : sourceTables) {
            Boolean activatedIdentityColumn;
            Boolean dataCopied;
            if (!tableNamesToCopy.contains(sourceTable.name.toUpperCase(Locale.UK))) continue;
            logger.info("copyTableData: Copying table '{}' ({} of {})...", new Object[]{sourceTable.name.toUpperCase(Locale.UK), ++tableIndex, tableNamesToCopy.size()});
            Table targetTable = (Table)Objects.requireNonNull(targetTableName2Table.get(sourceTable.name.toUpperCase(Locale.UK)), "targetTables[" + sourceTable.name.toUpperCase(Locale.UK) + "]");
            SortedMap<String, Column> sourceColumnName2Column = this.getColumnName2ColumnMap((Collection<Column>)Objects.requireNonNull(map.get(sourceTable), "sourceTable2Columns.get(" + sourceTable + ")"));
            SortedMap<String, Column> targetColumnName2Column = this.getColumnName2ColumnMap((Collection<Column>)Objects.requireNonNull(targetTable2Columns.get(targetTable), "targetTable2Columns.get(" + targetTable + ")"));
            TreeSet<String> sourceColumnNamesMissingInTarget = new TreeSet<String>(sourceColumnName2Column.keySet());
            sourceColumnNamesMissingInTarget.removeAll(targetColumnName2Column.keySet());
            TreeSet<String> targetColumnNamesMissingInSource = new TreeSet<String>(targetColumnName2Column.keySet());
            targetColumnNamesMissingInSource.removeAll(sourceColumnName2Column.keySet());
            if (sourceColumnNamesMissingInTarget.isEmpty()) {
                logger.info("copyTableData: Table '{}': All source-columns exist in the target-DB!", (Object)sourceTable.name.toUpperCase(Locale.UK));
            } else {
                logger.warn("copyTableData: Table '{}': The following source-columns are missing in the target-DB: {}", (Object)sourceTable.name.toUpperCase(Locale.UK), sourceColumnNamesMissingInTarget);
            }
            if (targetColumnNamesMissingInSource.isEmpty()) {
                logger.info("copyTableData: Table '{}': All target-columns exist in the source-DB!", (Object)sourceTable.name.toUpperCase(Locale.UK));
            } else {
                logger.warn("copyTableData: Table '{}': The following target-columns are missing in the source-DB: {}", (Object)sourceTable.name.toUpperCase(Locale.UK), targetColumnNamesMissingInSource);
            }
            Boolean passivatedIdentityColumn = this.getStatusTargetTableIdentityColumnPassivated(targetTable);
            if (passivatedIdentityColumn == null) {
                passivatedIdentityColumn = this.targetDbAdapter.passivateIdentityColumn(this.targetConnection, targetTable, targetColumnName2Column);
                this.setStatusTargetTableIdentityColumnPassivated(targetTable, passivatedIdentityColumn);
            }
            if (!Boolean.TRUE.equals(dataCopied = this.getStatusTableDataCopied(targetTable))) {
                this.copyTableData(sourceTable, targetTable, sourceColumnName2Column, targetColumnName2Column);
                this.setStatusTableDataCopied(targetTable, true);
            }
            if (passivatedIdentityColumn.booleanValue() && !Boolean.TRUE.equals(activatedIdentityColumn = this.getStatusTargetTableIdentityColumnActivated(targetTable))) {
                this.targetDbAdapter.activateIdentityColumn(this.targetConnection, targetTable, targetColumnName2Column);
                this.setStatusTargetTableIdentityColumnActivated(targetTable, true);
            }
            logger.info("copyTableData: Copied table '{}' ({} of {}).", new Object[]{sourceTable.name.toUpperCase(Locale.UK), tableIndex, tableNamesToCopy.size()});
        }
    }

    protected Boolean getStatusTableDataCopied(Table targetTable) {
        Objects.requireNonNull(targetTable, "targetTable");
        String statusKey = String.format(STATUS_TABLE_DATA_COPIED_FORMAT, targetTable.name.toUpperCase(Locale.UK));
        String statusValue = this.status.getProperty(statusKey);
        if (statusValue == null || statusValue.trim().isEmpty()) {
            return null;
        }
        return Boolean.parseBoolean(statusValue);
    }

    protected void setStatusTableDataCopied(Table targetTable, boolean value) throws Exception {
        Objects.requireNonNull(targetTable, "targetTable");
        String statusKey = String.format(STATUS_TABLE_DATA_COPIED_FORMAT, targetTable.name.toUpperCase(Locale.UK));
        this.status.setProperty(statusKey, Boolean.toString(value));
        this.writeStatus();
    }

    protected Boolean getStatusTargetTableIdentityColumnPassivated(Table targetTable) {
        Objects.requireNonNull(targetTable, "targetTable");
        String statusKey = String.format(STATUS_TARGET_TABLE_IDENTITY_COLUMN_PASSIVATED_FORMAT, targetTable.name.toUpperCase(Locale.UK));
        String statusValue = this.status.getProperty(statusKey);
        if (statusValue == null || statusValue.trim().isEmpty()) {
            return null;
        }
        return Boolean.parseBoolean(statusValue);
    }

    protected void setStatusTargetTableIdentityColumnPassivated(Table targetTable, boolean value) throws Exception {
        Objects.requireNonNull(targetTable, "targetTable");
        String statusKey = String.format(STATUS_TARGET_TABLE_IDENTITY_COLUMN_PASSIVATED_FORMAT, targetTable.name.toUpperCase(Locale.UK));
        this.status.setProperty(statusKey, Boolean.toString(value));
        this.writeStatus();
    }

    protected Boolean getStatusTargetTableIdentityColumnActivated(Table targetTable) {
        Objects.requireNonNull(targetTable, "targetTable");
        String statusKey = String.format(STATUS_TARGET_TABLE_IDENTITY_COLUMN_ACTIVATED_FORMAT, targetTable.name.toUpperCase(Locale.UK));
        String statusValue = this.status.getProperty(statusKey);
        if (statusValue == null || statusValue.trim().isEmpty()) {
            return null;
        }
        return Boolean.parseBoolean(statusValue);
    }

    protected void setStatusTargetTableIdentityColumnActivated(Table targetTable, boolean value) throws Exception {
        Objects.requireNonNull(targetTable, "targetTable");
        String statusKey = String.format(STATUS_TARGET_TABLE_IDENTITY_COLUMN_ACTIVATED_FORMAT, targetTable.name.toUpperCase(Locale.UK));
        this.status.setProperty(statusKey, Boolean.toString(value));
        this.writeStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyTableData(Table sourceTable, Table targetTable, SortedMap<String, Column> sourceColumnName2Column, SortedMap<String, Column> targetColumnName2Column) throws Exception {
        Objects.requireNonNull(sourceTable, "sourceTable");
        Objects.requireNonNull(targetTable, "targetTable");
        Objects.requireNonNull(sourceColumnName2Column, "sourceColumnName2Column");
        Objects.requireNonNull(targetColumnName2Column, "targetColumnName2Column");
        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        boolean sourceAutoCommit = this.sourceConnection.getAutoCommit();
        boolean targetAutoCommit = this.targetConnection.getAutoCommit();
        try {
            this.sourceConnection.setAutoCommit(false);
            this.targetConnection.setAutoCommit(false);
            TreeMap<Column, Column> sourceColumn2TargetColumn = new TreeMap<Column, Column>();
            for (Column sourceColumn : sourceColumnName2Column.values()) {
                Column targetColumn = (Column)targetColumnName2Column.get(sourceColumn.name.toUpperCase(Locale.UK));
                if (targetColumn == null) continue;
                sourceColumn2TargetColumn.put(sourceColumn, targetColumn);
            }
            try (Statement deleteStatement = this.targetConnection.createStatement();){
                String sql = String.format("delete from \"%s\"", targetTable.name);
                logger.debug("copyTableData: Executing: {}", (Object)sql);
                int rowsAffected = deleteStatement.executeUpdate(sql);
                logger.debug("copyTableData: Deleted {} rows from '{}'.", (Object)rowsAffected, (Object)targetTable.name);
            }
            this.targetConnection.commit();
            try (Statement sourceStatement = this.sourceConnection.createStatement();){
                long sourceTableRowCount;
                String sql = String.format("select count(*) from \"%s\"", sourceTable.name);
                logger.debug("copyTableData: Executing: {}", (Object)sql);
                try (ResultSet rs = sourceStatement.executeQuery(sql);){
                    if (!rs.next()) {
                        throw new IllegalStateException("'SELECT count(*)' failed to return a row!");
                    }
                    sourceTableRowCount = rs.getLong(1);
                    if (rs.next()) {
                        throw new IllegalStateException("'SELECT count(*)' returned multiple rows!");
                    }
                }
                logger.info("copyTableData: Table '{}' contains {} rows to be copied.", (Object)sourceTable.name.toUpperCase(Locale.UK), (Object)sourceTableRowCount);
                sql = "select ";
                int idx = 0;
                for (Map.Entry entry : sourceColumn2TargetColumn.entrySet()) {
                    Column sourceColumn = (Column)entry.getKey();
                    if (++idx > 1) {
                        sql = sql + ", ";
                    }
                    sql = sql + "\"" + sourceColumn.name + "\"";
                }
                sql = sql + " from \"" + sourceTable.name + "\"";
                logger.debug("copyTableData: Executing: {}", (Object)sql);
                try (ResultSet rs = sourceStatement.executeQuery(sql);){
                    sql = "insert into \"" + targetTable.name + "\" (";
                    idx = 0;
                    for (Map.Entry me : sourceColumn2TargetColumn.entrySet()) {
                        Column targetColumn = (Column)me.getValue();
                        if (++idx > 1) {
                            sql = sql + ", ";
                        }
                        sql = sql + "\"" + targetColumn.name + "\"";
                    }
                    sql = sql + ") values (";
                    idx = 0;
                    for (Map.Entry me : sourceColumn2TargetColumn.entrySet()) {
                        if (++idx > 1) {
                            sql = sql + ", ";
                        }
                        sql = sql + "?";
                    }
                    sql = sql + ")";
                    logger.debug("copyTableData: Preparing: {}", (Object)sql);
                    try (PreparedStatement preparedStatement = this.targetConnection.prepareStatement(sql);){
                        long rowCountProcessed = 0L;
                        while (rs.next()) {
                            idx = 0;
                            for (Map.Entry me : sourceColumn2TargetColumn.entrySet()) {
                                Object sourceValue;
                                Column sourceColumn = (Column)me.getKey();
                                Column targetColumn = (Column)me.getValue();
                                if ((sourceValue = rs.getObject(++idx)) instanceof Timestamp) {
                                    sourceValue = rs.getTimestamp(idx, utc);
                                } else if (sourceValue instanceof Date) {
                                    sourceValue = rs.getDate(idx, utc);
                                } else if (sourceValue instanceof Time) {
                                    sourceValue = rs.getTime(idx, utc);
                                }
                                Object targetValue = this.convertValue(sourceColumn, targetColumn, sourceValue);
                                if (logger.isTraceEnabled()) {
                                    logger.trace("copyTableData: tableName={} columnName={} columnIndex={} sourceJdbcType={} sourceValue.class={} sourceValue={} targetJdbcType={} targetValue.class={} targetValue={}", new Object[]{targetTable.name, targetColumn.name, idx, this.getJdbcTypeAsString(sourceColumn.dataType), sourceValue == null ? null : sourceValue.getClass().getName(), sourceValue, this.getJdbcTypeAsString(targetColumn.dataType), targetValue == null ? null : targetValue.getClass().getName(), targetValue});
                                }
                                if (targetValue == null) {
                                    int dataType = targetColumn.dataType;
                                    preparedStatement.setNull(idx, dataType);
                                    continue;
                                }
                                if (targetValue instanceof Timestamp) {
                                    preparedStatement.setTimestamp(idx, (Timestamp)targetValue, utc);
                                    continue;
                                }
                                if (targetValue instanceof Date) {
                                    preparedStatement.setDate(idx, (Date)targetValue, utc);
                                    continue;
                                }
                                if (targetValue instanceof Time) {
                                    preparedStatement.setTime(idx, (Time)targetValue, utc);
                                    continue;
                                }
                                preparedStatement.setObject(idx, targetValue);
                            }
                            int rowsAffected = preparedStatement.executeUpdate();
                            if (rowsAffected != 1) {
                                throw new IllegalStateException("INSERT caused rowsAffected=" + rowsAffected);
                            }
                            if (++rowCountProcessed % 1000L != 0L && rowCountProcessed != sourceTableRowCount) continue;
                            this.targetConnection.commit();
                            logger.info("copyTableData: Table '{}': {} of {} rows have been copied.", new Object[]{sourceTable.name.toUpperCase(Locale.UK), rowCountProcessed, sourceTableRowCount});
                        }
                    }
                }
            }
            this.sourceConnection.commit();
            this.targetConnection.commit();
        }
        finally {
            this.sourceConnection.rollback();
            this.targetConnection.rollback();
            this.sourceConnection.setAutoCommit(sourceAutoCommit);
            this.targetConnection.setAutoCommit(targetAutoCommit);
        }
    }

    protected String getJdbcTypeAsString(int dataType) {
        String string;
        if (jdbcTypeIntToString == null) {
            try {
                HashMap<Integer, String> m = new HashMap<Integer, String>();
                for (Field field : Types.class.getFields()) {
                    if (field.isSynthetic() || (field.getModifiers() & 8) == 0 || field.getType() != Integer.class && field.getType() != Integer.TYPE) continue;
                    Integer value = (Integer)field.get(null);
                    m.put(value, field.getName() + "(" + value + ")");
                }
                jdbcTypeIntToString = Collections.unmodifiableMap(m);
            }
            catch (Exception e) {
                logger.warn("getJdbcTypeAsString: " + e, (Throwable)e);
                jdbcTypeIntToString = Collections.emptyMap();
            }
        }
        if ((string = jdbcTypeIntToString.get(dataType)) != null) {
            return string;
        }
        return Integer.toString(dataType);
    }

    protected Object convertValue(Column sourceColumn, Column targetColumn, Object sourceValue) throws Exception {
        if (sourceValue == null) {
            return sourceValue;
        }
        if (sourceValue instanceof Clob) {
            Clob sourceClob = (Clob)sourceValue;
            long length = sourceClob.length();
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("sourceClob.length > Integer.MAX_VALUE!!!");
            }
            String string = sourceClob.getSubString(1L, (int)length);
            return string;
        }
        if (sourceValue instanceof Blob) {
            Blob sourceBlob = (Blob)sourceValue;
            long length = sourceBlob.length();
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("sourceBlob.length > Integer.MAX_VALUE!!!");
            }
            byte[] bytes = sourceBlob.getBytes(1L, (int)length);
            return bytes;
        }
        if (sourceColumn.dataType == targetColumn.dataType) {
            return sourceValue;
        }
        switch (targetColumn.dataType) {
            case -7: 
            case 16: {
                return this.toBoolean(sourceValue.toString());
            }
            case -1: 
            case 1: 
            case 12: {
                if (sourceValue instanceof Boolean) {
                    return (Boolean)sourceValue != false ? "Y" : "N";
                }
                return sourceValue.toString();
            }
        }
        return sourceValue;
    }

    protected boolean toBoolean(String string) {
        Objects.requireNonNull(string, "string");
        if (string.startsWith("y") || string.startsWith("Y")) {
            return true;
        }
        if (string.startsWith("n") || string.startsWith("N")) {
            return false;
        }
        if (string.startsWith("t") || string.startsWith("T")) {
            return true;
        }
        if (string.startsWith("f") || string.startsWith("F")) {
            return false;
        }
        if (string.startsWith("1")) {
            return true;
        }
        if (string.startsWith("0")) {
            return false;
        }
        throw new IllegalArgumentException("string cannot be interpreted as boolean: " + string);
    }

    protected SortedMap<String, Column> getColumnName2ColumnMap(Collection<Column> columns) {
        Objects.requireNonNull(columns, "columns");
        TreeMap<String, Column> columnName2Colum = new TreeMap<String, Column>();
        for (Column column : columns) {
            columnName2Colum.put(column.name.toUpperCase(Locale.UK), column);
        }
        return columnName2Colum;
    }

    protected Map<Table, List<Column>> getTable2Columns(Connection connection, Set<Table> tables) throws Exception {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(tables, "tables");
        HashMap<Table, Table> table2table = new HashMap<Table, Table>();
        HashMap<Table, List<Column>> table2Columns = new HashMap<Table, List<Column>>();
        for (Table table : tables) {
            table2table.put(table, table);
            table2Columns.put(table, new ArrayList());
        }
        try (ResultSet rs = connection.getMetaData().getColumns(null, null, null, null);){
            while (rs.next()) {
                Boolean autoIncrement;
                String catalogue = rs.getString("TABLE_CAT");
                String schema = rs.getString("TABLE_SCHEM");
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                int dataType = rs.getInt("DATA_TYPE");
                int size = rs.getInt("COLUMN_SIZE");
                String defaultValue = rs.getString("COLUMN_DEF");
                String autoInc = rs.getString("IS_AUTOINCREMENT");
                if (autoInc == null || autoInc.trim().isEmpty()) {
                    throw new IllegalStateException("Unknown 'IS_AUTOINCREMENT' not supported by us!");
                }
                if ("yes".equalsIgnoreCase(autoInc)) {
                    autoIncrement = true;
                } else if ("no".equalsIgnoreCase(autoInc)) {
                    autoIncrement = false;
                } else {
                    throw new IllegalStateException("Illegal value for 'IS_AUTOINCREMENT': " + autoInc);
                }
                Table table = new Table(catalogue, schema, tableName);
                List columns = (List)table2Columns.get(table);
                if (columns == null) {
                    logger.trace("getTable2Columns: Ignoring column '{}' for ignored table '{}'!", (Object)columnName, (Object)tableName);
                    continue;
                }
                table = (Table)Objects.requireNonNull(table2table.get(table), "table2table.get(" + table + ")");
                Column column = new Column(table, columnName, dataType, size, autoIncrement);
                columns.add(column);
            }
        }
        return table2Columns;
    }

    protected void createPersistenceManagerFactories() {
        this.closePersistenceManagerFactories();
        PersistencePropertiesProvider ppp = new PersistencePropertiesProvider(this.repositoryId, this.localRoot);
        Map<String, String> sourcePersistenceProperties = ppp.getPersistenceProperties();
        ppp = new PersistencePropertiesProvider(this.repositoryId, this.targetLocalRoot);
        ppp.setOverridePersistencePropertiesFile(this.getTargetPersistencePropertiesFile());
        Map<String, String> targetPersistenceProperties = ppp.getPersistenceProperties();
        this.sourcePmf = JDOHelper.getPersistenceManagerFactory(sourcePersistenceProperties);
        this.sourcePm = this.sourcePmf.getPersistenceManager();
        this.targetPmf = JDOHelper.getPersistenceManagerFactory(targetPersistenceProperties);
        this.targetPm = this.targetPmf.getPersistenceManager();
        CloudStorePersistenceCapableClassesProvider.Helper.initPersistenceCapableClasses(this.sourcePm);
        CloudStorePersistenceCapableClassesProvider.Helper.initPersistenceCapableClasses(this.targetPm);
    }

    protected void createJdbcConnections() {
        this.closeJdbcConnections();
        try {
            this.sourceDbAdapter = this.sourceDbAdapterFactory.createDatabaseAdapter();
            this.sourceDbAdapter.setRepositoryId(this.repositoryId);
            this.sourceDbAdapter.setLocalRoot(this.localRoot);
            this.targetDbAdapter = this.targetDbAdapterFactory.createDatabaseAdapter();
            this.targetDbAdapter.setRepositoryId(this.repositoryId);
            this.targetDbAdapter.setLocalRoot(this.targetLocalRoot);
            this.sourceConnection = this.sourceDbAdapter.createConnection();
            this.targetConnection = this.targetDbAdapter.createConnection();
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    protected void closeJdbcConnections() {
        try {
            if (this.sourceConnection != null) {
                this.sourceConnection.close();
                this.sourceConnection = null;
            }
            if (this.targetConnection != null) {
                this.targetConnection.close();
                this.targetConnection = null;
            }
            if (this.sourceDbAdapter != null) {
                this.sourceDbAdapter.close();
                this.sourceDbAdapter = null;
            }
            if (this.targetDbAdapter != null) {
                this.targetDbAdapter.close();
                this.targetDbAdapter = null;
            }
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    protected void closePersistenceManagerFactories() {
        if (this.sourcePm != null) {
            if (this.sourcePm.currentTransaction().isActive()) {
                this.sourcePm.currentTransaction().rollback();
            }
            this.sourcePm.close();
            this.sourcePm = null;
        }
        if (this.targetPm != null) {
            if (this.targetPm.currentTransaction().isActive()) {
                this.targetPm.currentTransaction().rollback();
            }
            this.targetPm.close();
            this.targetPm = null;
        }
        if (this.sourcePmf != null) {
            this.sourcePmf.close();
            this.sourcePmf = null;
        }
        if (this.targetPmf != null) {
            this.targetPmf.close();
            this.targetPmf = null;
        }
    }

    protected void createTargetPersistencePropertiesAndDatabase() throws Exception {
        Objects.requireNonNull(this.sourceDbAdapterFactory, "sourceDbAdapterFactory");
        Objects.requireNonNull(this.targetDbAdapterFactory, "targetDbAdapterFactory");
        this.targetLocalRoot.mkdir();
        this.targetMetaDir.mkdir();
        if (!this.targetMetaDir.isDirectory()) {
            throw new IllegalStateException("Creating directory failed: " + this.targetMetaDir.getAbsolutePath());
        }
        if (this.getTargetPersistencePropertiesFile().exists()) {
            File directory = this.getTargetPersistencePropertiesFile().getParentFile();
            File backupFile = directory.createFile(new String[]{this.getTargetPersistencePropertiesFile().getName() + ".bak_" + Long.toHexString(System.currentTimeMillis())});
            this.getTargetPersistencePropertiesFile().renameTo(backupFile);
            if (this.getTargetPersistencePropertiesFile().exists()) {
                throw new IOException(String.format("Renaming file '%s' to '%s' (in directory '%s') failed!", this.getTargetPersistencePropertiesFile().getName(), backupFile.getName(), directory.getAbsolutePath()));
            }
        }
        try (DatabaseAdapter targetDatabaseAdapter = this.targetDbAdapterFactory.createDatabaseAdapter();){
            targetDatabaseAdapter.setRepositoryId(this.repositoryId);
            targetDatabaseAdapter.setLocalRoot(this.targetLocalRoot);
            targetDatabaseAdapter.createPersistencePropertiesFileAndDatabase();
        }
        if (!this.getTargetPersistencePropertiesFile().exists()) {
            throw new IOException(String.format("Creating persistence-properties '%s' failed!", this.getTargetPersistencePropertiesFile().getAbsolutePath()));
        }
    }

    protected File getSourcePersistencePropertiesFile() {
        return this.metaDir.createFile(new String[]{LocalRepoManager.PERSISTENCE_PROPERTIES_FILE_NAME});
    }

    protected File getTargetPersistencePropertiesFile() {
        return this.targetMetaDir.createFile(new String[]{LocalRepoManager.PERSISTENCE_PROPERTIES_FILE_NAME});
    }

    protected Properties readRawPersistenceProperties() throws IOException {
        File persistencePropertiesFile = OioFileFactory.createFile((File)this.metaDir, (String[])new String[]{LocalRepoManager.PERSISTENCE_PROPERTIES_FILE_NAME});
        if (!persistencePropertiesFile.isFile()) {
            throw new IllegalStateException("The persistencePropertiesFile does not exist or is not a file: " + persistencePropertiesFile.getAbsolutePath());
        }
        Properties rawProperties = PropertiesUtil.load((File)persistencePropertiesFile);
        return rawProperties;
    }

    protected void readStatus() throws IOException {
        File statusFile = this.getStatusFile();
        if (statusFile.exists()) {
            try (IInputStream in = this.getStatusFile().createInputStream();){
                this.status.load(StreamUtil.castStream((IInputStream)in));
            }
        }
    }

    protected void writeStatus() throws IOException {
        try (IOutputStream out = this.getStatusFile().createOutputStream();){
            this.status.store(StreamUtil.castStream((IOutputStream)out), null);
        }
    }

    protected File getTriggerFile() {
        return this.metaDir.createFile(new String[]{DBMIGRATE_TRIGGER_FILE_NAME});
    }

    protected File getStatusFile() {
        return this.metaDir.createFile(new String[]{DBMIGRATE_STATUS_FILE_NAME});
    }

    public boolean isMigrationInProcess() {
        if (this.repositoryId == null) {
            return false;
        }
        File persistencePropertiesFile = OioFileFactory.createFile((File)this.metaDir, (String[])new String[]{LocalRepoManager.PERSISTENCE_PROPERTIES_FILE_NAME});
        if (!persistencePropertiesFile.isFile()) {
            return false;
        }
        File statusFile = this.getStatusFile();
        File triggerFile = this.getTriggerFile();
        return statusFile.exists() || !triggerFile.exists();
    }

    public void createTriggerFile() {
        try {
            File triggerFile = this.getTriggerFile();
            triggerFile.createNewFile();
            if (!triggerFile.isFile()) {
                throw new IOException("Creating file failed: " + triggerFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testTargetPersistence() throws Exception {
        long nf0Id;
        RepoFile rootDir;
        RepoFileDao rfDao;
        NormalFileDao nfDao;
        Objects.requireNonNull(this.targetPm, "targetPm");
        String nf0Name = "test_" + Long.toString(System.currentTimeMillis(), 36) + "_" + new Uid();
        this.targetPm.currentTransaction().begin();
        try {
            nfDao = this.getDao(NormalFileDao.class);
            rfDao = this.getDao(RepoFileDao.class);
            rootDir = rfDao.getChildRepoFile(null, "");
            Objects.requireNonNull(rootDir, "rootDir");
            if (!(rootDir instanceof Directory)) {
                throw new IllegalStateException("rootDir is an instance of " + rootDir.getClass().getName() + ", but it must be an instance of Directory: " + rootDir);
            }
            NormalFile nf = (NormalFile)ObjectFactoryUtil.createObject(NormalFile.class);
            nf.setLastModified(new java.util.Date());
            nf.setParent(rootDir);
            nf.setName(nf0Name);
            nf.setSha1("xyz");
            nf.setLength(666L);
            nf = rfDao.makePersistent(nf);
            nfDao.getPersistenceManager().flush();
            nf0Id = nf.getId();
            nfDao.getObjectByIdOrFail(nf0Id);
            RepoFile nf0 = rfDao.getChildRepoFile(rootDir, nf0Name);
            Objects.requireNonNull(nf0, "nf0");
            if (nf0.getId() != nf0Id) {
                throw new IllegalStateException(String.format("nf0.getId() != nf0Id :: %s != %s", nf0.getId(), nf0Id));
            }
        }
        finally {
            this.targetPm.currentTransaction().rollback();
        }
        this.targetPm.currentTransaction().begin();
        try {
            nfDao = this.getDao(NormalFileDao.class);
            rfDao = this.getDao(RepoFileDao.class);
            rootDir = rfDao.getChildRepoFile(null, "");
            Objects.requireNonNull(rootDir, "rootDir");
            RepoFile nf0 = rfDao.getChildRepoFile(rootDir, nf0Name);
            if (nf0 != null) {
                throw new IllegalStateException("Data written in rolled-back transaction is still there!");
            }
            nf0 = (RepoFile)nfDao.getObjectByIdOrNull(nf0Id);
            if (nf0 != null) {
                throw new IllegalStateException("Data written in rolled-back transaction is still there!");
            }
        }
        finally {
            this.targetPm.currentTransaction().rollback();
        }
        this.sourcePm.currentTransaction().begin();
        this.targetPm.currentTransaction().begin();
        try {
            for (Class<?> pcClass : CloudStorePersistenceCapableClassesProvider.Helper.getPersistenceCapableClasses()) {
                if (!Entity.class.isAssignableFrom(pcClass) || (pcClass.getModifiers() & 0x400) != 0) continue;
                this.comparePersistentObjects(pcClass);
            }
        }
        finally {
            this.sourcePm.currentTransaction().rollback();
            this.targetPm.currentTransaction().rollback();
        }
    }

    protected void comparePersistentObjects(Class<?> pcClass) throws Exception {
        long maxId;
        Objects.requireNonNull(pcClass, "pcClass");
        long idBlockSize = 1000L;
        long minId = this.getComparePersistentObjectsMinId(pcClass);
        if (minId == Long.MIN_VALUE) {
            long targetMinId;
            minId = this.getMinId(this.sourcePm, pcClass);
            if (minId != (targetMinId = this.getMinId(this.targetPm, pcClass))) {
                throw new IllegalStateException(String.format("%s: sourceMinId != targetMinId :: %d != %d", pcClass.getName(), minId, targetMinId));
            }
            this.setComparePersistentObjectsMinId(pcClass, minId);
        }
        if ((maxId = this.getComparePersistentObjectsMaxId(pcClass)) == Long.MIN_VALUE) {
            long targetMaxId;
            maxId = this.getMaxId(this.sourcePm, pcClass);
            if (maxId != (targetMaxId = this.getMaxId(this.targetPm, pcClass))) {
                throw new IllegalStateException(String.format("%s: sourceMaxId != targetMaxId :: %d != %d", pcClass.getName(), maxId, targetMaxId));
            }
            this.setComparePersistentObjectsMaxId(pcClass, maxId);
        }
        if (minId == Long.MIN_VALUE || maxId == Long.MIN_VALUE) {
            if (minId != maxId) {
                throw new IllegalStateException(String.format("%s: minId != maxId :: %d != %d", pcClass.getName(), minId, maxId));
            }
            logger.debug("comparePersistentObjects: pcClass={}: *EMPTY*", (Object)pcClass.getName());
            return;
        }
        logger.debug("comparePersistentObjects: pcClass={}: minId={} maxId={}", new Object[]{pcClass.getName(), minId, maxId});
        long objectCount = this.getComparePersistentObjectsObjectCount(pcClass);
        long fromIdIncl = this.getComparePersistentObjectsFromIdIncl(pcClass);
        if (fromIdIncl == Long.MIN_VALUE) {
            fromIdIncl = minId;
        }
        while (fromIdIncl <= maxId) {
            long toIdExcl = fromIdIncl + 1000L;
            fromIdIncl = toIdExcl;
            this.setComparePersistentObjectsFromIdIncl(pcClass, fromIdIncl);
            this.setComparePersistentObjectsObjectCount(pcClass, objectCount += (long)this.comparePersistentObjects(pcClass, fromIdIncl, toIdExcl));
        }
        logger.info("comparePersistentObjects: pcClass={}: {} objects are equal.", (Object)pcClass.getName(), (Object)objectCount);
    }

    protected long getComparePersistentObjectsMinId(Class<?> pcClass) {
        Objects.requireNonNull(pcClass, "pcClass");
        String statusKey = String.format(STATUS_COMPARE_PERSISTENT_OBECTS_MIN_ID_FORMAT, pcClass.getName());
        String statusValue = this.status.getProperty(statusKey);
        if (statusValue == null || statusValue.trim().isEmpty()) {
            return Long.MIN_VALUE;
        }
        return Long.parseLong(statusValue);
    }

    protected void setComparePersistentObjectsMinId(Class<?> pcClass, long id) throws Exception {
        Objects.requireNonNull(pcClass, "pcClass");
        String statusKey = String.format(STATUS_COMPARE_PERSISTENT_OBECTS_MIN_ID_FORMAT, pcClass.getName());
        this.status.setProperty(statusKey, id == Long.MIN_VALUE ? "" : Long.toString(id));
        this.writeStatus();
    }

    protected long getComparePersistentObjectsMaxId(Class<?> pcClass) {
        Objects.requireNonNull(pcClass, "pcClass");
        String statusKey = String.format(STATUS_COMPARE_PERSISTENT_OBECTS_MAX_ID_FORMAT, pcClass.getName());
        String statusValue = this.status.getProperty(statusKey);
        if (statusValue == null || statusValue.trim().isEmpty()) {
            return Long.MIN_VALUE;
        }
        return Long.parseLong(statusValue);
    }

    protected void setComparePersistentObjectsMaxId(Class<?> pcClass, long id) throws Exception {
        Objects.requireNonNull(pcClass, "pcClass");
        String statusKey = String.format(STATUS_COMPARE_PERSISTENT_OBECTS_MAX_ID_FORMAT, pcClass.getName());
        this.status.setProperty(statusKey, id == Long.MIN_VALUE ? "" : Long.toString(id));
        this.writeStatus();
    }

    protected long getComparePersistentObjectsFromIdIncl(Class<?> pcClass) {
        Objects.requireNonNull(pcClass, "pcClass");
        String statusKey = String.format(STATUS_COMPARE_PERSISTENT_OBECTS_FROM_ID_INCL_FORMAT, pcClass.getName());
        String statusValue = this.status.getProperty(statusKey);
        if (statusValue == null || statusValue.trim().isEmpty()) {
            return Long.MIN_VALUE;
        }
        return Long.parseLong(statusValue);
    }

    protected void setComparePersistentObjectsFromIdIncl(Class<?> pcClass, long id) throws Exception {
        Objects.requireNonNull(pcClass, "pcClass");
        String statusKey = String.format(STATUS_COMPARE_PERSISTENT_OBECTS_FROM_ID_INCL_FORMAT, pcClass.getName());
        this.status.setProperty(statusKey, id == Long.MIN_VALUE ? "" : Long.toString(id));
        this.writeStatus();
    }

    protected long getComparePersistentObjectsObjectCount(Class<?> pcClass) {
        Objects.requireNonNull(pcClass, "pcClass");
        String statusKey = String.format(STATUS_COMPARE_PERSISTENT_OBECTS_OBJECT_COUNT_FORMAT, pcClass.getName());
        String statusValue = this.status.getProperty(statusKey);
        if (statusValue == null || statusValue.trim().isEmpty()) {
            return 0L;
        }
        return Long.parseLong(statusValue);
    }

    protected void setComparePersistentObjectsObjectCount(Class<?> pcClass, long count) throws Exception {
        Objects.requireNonNull(pcClass, "pcClass");
        String statusKey = String.format(STATUS_COMPARE_PERSISTENT_OBECTS_OBJECT_COUNT_FORMAT, pcClass.getName());
        this.status.setProperty(statusKey, count == Long.MIN_VALUE ? "" : Long.toString(count));
        this.writeStatus();
    }

    protected int comparePersistentObjects(Class<?> pcClass, long fromIdIncl, long toIdExcl) {
        Objects.requireNonNull(pcClass, "pcClass");
        List<Entity> sourceObjects = this.getPersistentObjects(this.sourcePm, pcClass, fromIdIncl, toIdExcl);
        List<Entity> targetObjects = this.getPersistentObjects(this.targetPm, pcClass, fromIdIncl, toIdExcl);
        int result = sourceObjects.size();
        if (result != targetObjects.size()) {
            throw new IllegalStateException(String.format("%s: fromIdIncl=%d toIdExcl=%d :: sourceObjects.size != targetObjects.size :: %d != %d", pcClass.getName(), fromIdIncl, toIdExcl, result, targetObjects.size()));
        }
        Iterator<Entity> targetIterator = targetObjects.iterator();
        for (Entity sourceObject : sourceObjects) {
            Entity targetObject = targetIterator.next();
            if (sourceObject.getId() != targetObject.getId()) {
                throw new IllegalStateException(String.format("%s: fromIdIncl=%d toIdExcl=%d :: sourceObject.id != targetObjects.id :: %d != %d", pcClass.getName(), fromIdIncl, toIdExcl, sourceObject.getId(), targetObject.getId()));
            }
            this.comparePersistentObject(sourceObject, targetObject);
        }
        logger.debug("comparePersistentObjects: pcClass={} fromIdIncl={} toIdExcl={}: {} objects are equal.", new Object[]{pcClass.getName(), fromIdIncl, toIdExcl, result});
        this.sourcePm.currentTransaction().rollback();
        this.sourcePm.evictAll();
        this.sourcePm.close();
        this.sourcePm = null;
        this.sourcePm = this.sourcePmf.getPersistenceManager();
        this.sourcePm.currentTransaction().begin();
        this.targetPm.currentTransaction().rollback();
        this.targetPm.evictAll();
        this.targetPm.close();
        this.targetPm = null;
        this.targetPm = this.targetPmf.getPersistenceManager();
        this.targetPm.currentTransaction().begin();
        DebugUtil.logMemoryStats((Logger)logger);
        return result;
    }

    protected void comparePersistentObject(Entity sourceObject, Entity targetObject) {
        Objects.requireNonNull(sourceObject, "sourceObject");
        Objects.requireNonNull(targetObject, "targetObject");
        if (sourceObject.getId() != targetObject.getId()) {
            throw new IllegalStateException(String.format("sourceObject.id != targetObjects.id :: %d != %d", sourceObject.getId(), targetObject.getId()));
        }
        Class<?> objectClass = sourceObject.getClass();
        if (objectClass != targetObject.getClass()) {
            throw new IllegalStateException(String.format("sourceObject.class != targetObjects.class :: %s != %s", objectClass.getName(), targetObject.getClass().getName()));
        }
        for (Method getter : this.getGetters(objectClass)) {
            String propertyName = DatabaseMigrater.getPropertyName(getter);
            Object sourceValue = this.invokeGetter(getter, sourceObject);
            Object targetValue = this.invokeGetter(getter, targetObject);
            this.comparePropertyValue(sourceObject, targetObject, propertyName, sourceValue, targetValue);
        }
    }

    protected void comparePropertyValue(Entity sourceObject, Entity targetObject, String propertyName, Object sourceValue, Object targetValue) {
        Objects.requireNonNull(sourceObject, "sourceObject");
        Objects.requireNonNull(targetObject, "targetObject");
        Objects.requireNonNull(propertyName, "propertyName");
        if (sourceValue == null) {
            if (targetValue == null) {
                return;
            }
            throw new IllegalStateException(String.format("Property '%s' of %s differs between source and target: sourceValue=null targetValue='%s'", propertyName, sourceObject, targetValue));
        }
        if (targetValue == null) {
            throw new IllegalStateException(String.format("Property '%s' of %s differs between source and target: sourceValue='%s' targetValue=null", propertyName, sourceObject, sourceValue));
        }
        if (sourceValue.getClass() != targetValue.getClass()) {
            throw new IllegalStateException(String.format("Property '%s' of %s differs between source and target: Class mismatch! sourceValue.class=%s targetValue.class=%s sourceValue='%s' targetValue='%s'", propertyName, sourceObject, sourceValue.getClass().getName(), targetValue.getClass().getName(), sourceValue, targetValue));
        }
        if (sourceValue.getClass().isArray()) {
            if (!DatabaseMigrater.arrayEquals(sourceValue, targetValue)) {
                throw new IllegalStateException(String.format("Property '%s' of %s differs between source and target: sourceValue=%s targetValue=%s", propertyName, sourceObject, DatabaseMigrater.arrayToString(sourceValue), DatabaseMigrater.arrayToString(targetValue)));
            }
        } else if (!sourceValue.equals(targetValue)) {
            throw new IllegalStateException(String.format("Property '%s' of %s differs between source and target: sourceValue='%s' targetValue='%s'", propertyName, sourceObject, sourceValue, targetValue));
        }
    }

    protected static String arrayToString(Object array) {
        Objects.requireNonNull(array, "array");
        if (array instanceof boolean[]) {
            return Arrays.toString((boolean[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.toString((byte[])array);
        }
        if (array instanceof char[]) {
            return Arrays.toString((char[])array);
        }
        if (array instanceof double[]) {
            return Arrays.toString((double[])array);
        }
        if (array instanceof float[]) {
            return Arrays.toString((float[])array);
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        if (array instanceof short[]) {
            return Arrays.toString((short[])array);
        }
        if (array instanceof Object[]) {
            return Arrays.toString((Object[])array);
        }
        throw new IllegalArgumentException("Unexpected type: " + array.getClass().getName());
    }

    protected static boolean arrayEquals(Object sourceArray, Object targetArray) {
        Objects.requireNonNull(sourceArray, "sourceArray");
        Objects.requireNonNull(targetArray, "targetArray");
        if (sourceArray instanceof boolean[]) {
            return Arrays.equals((boolean[])sourceArray, (boolean[])targetArray);
        }
        if (sourceArray instanceof byte[]) {
            return Arrays.equals((byte[])sourceArray, (byte[])targetArray);
        }
        if (sourceArray instanceof char[]) {
            return Arrays.equals((char[])sourceArray, (char[])targetArray);
        }
        if (sourceArray instanceof double[]) {
            return Arrays.equals((double[])sourceArray, (double[])targetArray);
        }
        if (sourceArray instanceof float[]) {
            return Arrays.equals((float[])sourceArray, (float[])targetArray);
        }
        if (sourceArray instanceof int[]) {
            return Arrays.equals((int[])sourceArray, (int[])targetArray);
        }
        if (sourceArray instanceof long[]) {
            return Arrays.equals((long[])sourceArray, (long[])targetArray);
        }
        if (sourceArray instanceof short[]) {
            return Arrays.equals((short[])sourceArray, (short[])targetArray);
        }
        if (sourceArray instanceof Object[]) {
            return Arrays.equals((Object[])sourceArray, (Object[])targetArray);
        }
        throw new IllegalArgumentException("Unexpected type: " + sourceArray.getClass().getName());
    }

    protected Object invokeGetter(Method getter, Object object) {
        Objects.requireNonNull(getter, "getter");
        Objects.requireNonNull(object, "object");
        try {
            return getter.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Getter for property '%s' on %s failed: %s", DatabaseMigrater.getPropertyName(getter), object, e), e);
        }
    }

    protected List<Method> getGetters(Class<? extends Entity> objectClass) {
        Objects.requireNonNull(objectClass, "objectClass");
        List<Method> getters = this.objectClass2Getters.get(objectClass);
        if (getters == null) {
            getters = new ArrayList<Method>();
            for (Method method : objectClass.getMethods()) {
                IgnoreDatabaseMigraterComparison ignore;
                if (method.getParameterCount() != 0 || !DatabaseMigrater.isGetterName(method.getName()) || (ignore = method.getAnnotation(IgnoreDatabaseMigraterComparison.class)) != null) continue;
                getters.add(method);
            }
            this.objectClass2Getters.put(objectClass, getters);
        }
        return getters;
    }

    protected static String getPropertyName(Method method) {
        String propertyName;
        String methodName = Objects.requireNonNull(method, "method").getName();
        if (methodName.startsWith("get")) {
            propertyName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            propertyName = methodName.substring(2);
        } else {
            throw new IllegalArgumentException("method.name is not a valid getter-name (wrong prefix): " + method);
        }
        if (propertyName.isEmpty()) {
            throw new IllegalArgumentException("method.name is not a valid getter-name (too short): " + method);
        }
        return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    protected static boolean isGetterName(String methodName) {
        Objects.requireNonNull(methodName, "methodName");
        return methodName.startsWith("get") && methodName.length() > 3 || methodName.startsWith("is") && methodName.length() > 2;
    }

    protected long getMinId(PersistenceManager pm, Class<?> pcClass) {
        Objects.requireNonNull(pm, "pm");
        Objects.requireNonNull(pcClass, "pcClass");
        Query query = pm.newQuery(pcClass);
        Long result = (Long)query.result("min(this.id)").execute();
        query.closeAll();
        return result == null ? Long.MIN_VALUE : result;
    }

    protected long getMaxId(PersistenceManager pm, Class<?> pcClass) {
        Objects.requireNonNull(pm, "pm");
        Objects.requireNonNull(pcClass, "pcClass");
        Query query = pm.newQuery(pcClass);
        Long result = (Long)query.result("max(this.id)").execute();
        query.closeAll();
        return result == null ? Long.MIN_VALUE : result;
    }

    protected List<Entity> getPersistentObjects(PersistenceManager pm, Class<?> pcClass, long fromIdIncl, long toIdExcl) {
        Objects.requireNonNull(pm, "pm");
        Objects.requireNonNull(pcClass, "pcClass");
        Query query = pm.newQuery(pcClass);
        FetchPlan fetchPlan = query.getFetchPlan();
        fetchPlan.clearGroups();
        fetchPlan.addGroup("all");
        fetchPlan.setMaxFetchDepth(1);
        ArrayList<Entity> result = (ArrayList<Entity>)query.filter("this.id >= :fromIdIncl && this.id < :toIdExcl").orderBy("this.id ASCENDING").execute((Object)fromIdIncl, (Object)toIdExcl);
        result = new ArrayList<Entity>(result);
        query.closeAll();
        return result;
    }

    public <D> D getDao(Class<D> daoClass) {
        Objects.requireNonNull(daoClass, "daoClass");
        Object dao = this.daoClass2Dao.get(daoClass);
        if (dao != null && ((Dao)dao).getPersistenceManager() != this.targetPm) {
            dao = null;
        }
        if (dao == null) {
            dao = ObjectFactoryUtil.createObject(daoClass);
            if (!(dao instanceof Dao)) {
                throw new IllegalStateException(String.format("dao class %s does not extend Dao!", daoClass.getName()));
            }
            ((Dao)dao).setPersistenceManager(this.targetPm);
            ((Dao)dao).setDaoProvider(this);
            this.daoClass2Dao.put(daoClass, dao);
        }
        return (D)dao;
    }
}

