/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class LsConfig {
    private static final Uid PROCESS_ID = new Uid();
    public static final String CONFIG_KEY_LOCAL_SERVER_ENABLED = "localServer.enabled";
    public static final boolean DEFAULT_LOCAL_SERVER_ENABLED = true;
    public static final String CONFIG_KEY_LOCAL_SERVER_PROCESS_ENABLED = "localServerProcess.enabled";
    public static final boolean DEFAULT_LOCAL_SERVER_PROCESS_ENABLED = true;
    public static final String CONFIG_KEY_LOCAL_SERVER_PROCESS_START_TIMEOUT = "localServerProcess.startTimeout";
    public static final long DEFAULT_LOCAL_SERVER_PROCESS_START_TIMEOUT = 120000L;
    public static final String CONFIG_KEY_LOCAL_SERVER_PROCESS_MAX_HEAP_SIZE = "localServerProcess.maxHeapSize";
    public static final String DEFAULT_LOCAL_SERVER_PROCESS_MAX_HEAP_SIZE = "";
    public static final Pattern CONFIG_KEY_PATTERN_LOCAL_SERVER_PROCESS_VM_ARGS = Pattern.compile("localServerProcess\\.vmArgs\\[([^]]+)\\]");

    private LsConfig() {
    }

    public static boolean isLocalServerEnabled() {
        return ConfigImpl.getInstance().getPropertyAsBoolean(CONFIG_KEY_LOCAL_SERVER_ENABLED, true);
    }

    public static boolean isLocalServerProcessEnabled() {
        return ConfigImpl.getInstance().getPropertyAsBoolean(CONFIG_KEY_LOCAL_SERVER_PROCESS_ENABLED, true);
    }

    public static long getLocalServerProcessStartTimeout() {
        long timeoutMs = ConfigImpl.getInstance().getPropertyAsPositiveOrZeroLong(CONFIG_KEY_LOCAL_SERVER_PROCESS_START_TIMEOUT, 120000L);
        return timeoutMs;
    }

    public static String getLocalServerProcessMaxHeapSize() {
        String maxHeapSize = ConfigImpl.getInstance().getPropertyAsNonEmptyTrimmedString(CONFIG_KEY_LOCAL_SERVER_PROCESS_MAX_HEAP_SIZE, DEFAULT_LOCAL_SERVER_PROCESS_MAX_HEAP_SIZE);
        return StringUtil.emptyToNull((String)maxHeapSize);
    }

    public static List<String> getLocalServerProcessVmArgs() {
        ArrayList<String> result = new ArrayList<String>();
        Config config = ConfigImpl.getInstance();
        Map key2GroupsMatching = config.getKey2GroupsMatching(CONFIG_KEY_PATTERN_LOCAL_SERVER_PROCESS_VM_ARGS);
        TreeSet keys = new TreeSet(key2GroupsMatching.keySet());
        for (String key : keys) {
            String value = config.getPropertyAsNonEmptyTrimmedString(key, null);
            if (value == null || value.isEmpty()) continue;
            result.add(value);
        }
        return result;
    }

    public static Uid getProcessId() {
        return PROCESS_ID;
    }
}

