/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core;

import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import java.util.Objects;
import java.util.UUID;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactory;
import org.subshare.core.user.UserRepoKeyRing;

public abstract class AbstractCryptree
implements Cryptree {
    private CryptreeFactory cryptreeFactory;
    private LocalRepoTransaction transaction;
    private UserRepoKeyRing userRepoKeyRing;
    private UUID remoteRepositoryId;
    private String remotePathPrefix;

    @Override
    public CryptreeFactory getCryptreeFactory() {
        return this.cryptreeFactory;
    }

    @Override
    public void setCryptreeFactory(CryptreeFactory cryptreeFactory) {
        if (this.cryptreeFactory != null && this.cryptreeFactory != cryptreeFactory) {
            throw new IllegalStateException("this.cryptreeFactory already assigned! Cannot modify after initial assignment!");
        }
        this.cryptreeFactory = cryptreeFactory;
    }

    protected CryptreeFactory getCryptreeFactoryOrFail() {
        return Objects.requireNonNull(this.getCryptreeFactory(), "getCryptreeFactory()");
    }

    @Override
    public LocalRepoTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void setTransaction(LocalRepoTransaction transaction) {
        if (this.transaction != null && this.transaction != transaction) {
            throw new IllegalStateException("this.transaction already assigned! Cannot modify after initial assignment!");
        }
        this.transaction = transaction;
    }

    protected LocalRepoTransaction getTransactionOrFail() {
        return Objects.requireNonNull(this.getTransaction(), "getTransaction()");
    }

    @Override
    public UserRepoKeyRing getUserRepoKeyRing() {
        return this.userRepoKeyRing;
    }

    @Override
    public void setUserRepoKeyRing(UserRepoKeyRing userRepoKeyRing) {
        this.userRepoKeyRing = userRepoKeyRing;
    }

    protected UserRepoKeyRing getUserRepoKeyRingOrFail() {
        return Objects.requireNonNull(this.getUserRepoKeyRing(), "getUserRepoKeyRing()");
    }

    @Override
    public UUID getRemoteRepositoryId() {
        return this.remoteRepositoryId;
    }

    @Override
    public void setRemoteRepositoryId(UUID serverRepositoryId) {
        if (this.remoteRepositoryId != null && !this.remoteRepositoryId.equals(serverRepositoryId)) {
            throw new IllegalStateException("this.remoteRepositoryId already assigned! Cannot modify after initial assignment!");
        }
        this.remoteRepositoryId = serverRepositoryId;
    }

    protected UUID getRemoteRepositoryIdOrFail() {
        return Objects.requireNonNull(this.getRemoteRepositoryId(), "getRemoteRepositoryId()");
    }

    @Override
    public String getRemotePathPrefix() {
        return this.remotePathPrefix;
    }

    @Override
    public void setRemotePathPrefix(String remotePathPrefix) {
        if (this.remotePathPrefix != null && !this.remotePathPrefix.equals(remotePathPrefix)) {
            throw new IllegalStateException("this.remotePathPrefix already assigned! Cannot modify after initial assignment!");
        }
        this.remotePathPrefix = remotePathPrefix;
    }

    protected String getRemotePathPrefixOrFail() {
        return Objects.requireNonNull(this.getRemotePathPrefix(), "getRemotePathPrefix()");
    }
}

