/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import org.bouncycastle.pqc.crypto.qtesla.CommonFunction;
import org.bouncycastle.pqc.crypto.qtesla.FederalInformationProcessingStandard202;
import org.bouncycastle.pqc.crypto.qtesla.PolynomialHeuristic;
import org.bouncycastle.pqc.crypto.qtesla.PolynomialProvablySecure;

public class Polynomial {
    public static final short RANDOM_BYTE = 32;
    public static final short SEED_BYTE = 32;
    public static final short C_BYTE = 32;
    public static final short BYTE_I = 1376;
    public static final short BYTE_III_SIZE = 2720;
    public static final short BYTE_III_SPEED = 2848;
    public static final short BYTE_I_P = 2848;
    public static final short BYTE_III_P = 6176;
    public static final int PUBLIC_KEY_BYTE_I = 1504;
    public static final int PUBLIC_KEY_BYTE_III_SIZE = 2976;
    public static final int PUBLIC_KEY_BYTE_III_SPEED = 3104;
    public static final int PUBLIC_KEY_BYTE_I_P = 14880;
    public static final int PUBLIC_KEY_BYTE_III_P = 39712;
    public static final int SECRET_KEY_BYTE_I = 2112;
    public static final int SECRET_KEY_BYTE_III_SIZE = 4160;
    public static final int SECRET_KEY_BYTE_III_SPEED = 4160;
    public static final int SECRET_KEY_BYTE_I_P = 5184;
    public static final int SECRET_KEY_BYTE_III_P = 12352;
    private CommonFunction function = new CommonFunction();
    private FederalInformationProcessingStandard202 fips = new FederalInformationProcessingStandard202();

    private long montgomery(long number, int q, long qInverse) {
        long u = number * qInverse & 0xFFFFFFFFL;
        return number + u * (long)q >> 32;
    }

    public int barrett(long number, int q, short barrettMultiplication, short barrettDivision) {
        return (int)(number - (number * (long)barrettMultiplication >> barrettDivision) * (long)q);
    }

    public long barrettP(long number, int q, short barrettMultiplication, short barrettDivision) {
        return number - (number * (long)barrettMultiplication >> barrettDivision) * (long)q;
    }

    private void numberTheoreticTransform(long[] destination, long[] source, short n, int q, long qInverse) {
        int jTwiddle = 0;
        for (short numberOfProblem = (short)(n >>> 1); numberOfProblem > 0; numberOfProblem = (short)(numberOfProblem >> 1)) {
            short j = 0;
            short jFirst = 0;
            while (jFirst < n) {
                int n2 = jTwiddle;
                jTwiddle = (short)(jTwiddle + 1);
                int omega = (int)source[n2];
                for (j = jFirst; j < jFirst + numberOfProblem; j = (short)(j + 1)) {
                    int temporary = (int)this.montgomery((long)omega * destination[j + numberOfProblem], q, qInverse);
                    destination[j + numberOfProblem] = destination[j] + (long)q - (long)temporary;
                    destination[j] = destination[j] + (long)temporary;
                }
                jFirst = (short)(j + numberOfProblem);
            }
        }
    }

    private void numberTheoreticTransform(long[] destination, long[] source) {
        int jTwiddle = 0;
        for (int numberOfProblem = 1024; numberOfProblem > 0; numberOfProblem = (int)((short)(numberOfProblem >> 1))) {
            int j = 0;
            int jFirst = 0;
            while (jFirst < 2048) {
                int n = jTwiddle;
                jTwiddle = (short)(jTwiddle + 1);
                long omega = source[n];
                for (j = jFirst; j < jFirst + numberOfProblem; j = (int)((short)(j + 1))) {
                    int temporary = (int)this.barrettP(this.montgomery(omega * destination[j + numberOfProblem], 1129725953, 861290495L), 1129725953, (short)15, (short)34);
                    destination[j + numberOfProblem] = this.barrettP(destination[j] + -2035515390L - (long)temporary, 1129725953, (short)15, (short)34);
                    destination[j] = this.barrettP(destination[j] + (long)temporary, 1129725953, (short)15, (short)34);
                }
                jFirst = (short)(j + numberOfProblem);
            }
        }
    }

    private void inverseNumberTheoreticTransformI(long[] destination, long[] source) {
        int jTwiddle = 0;
        for (int numberOfProblem = 1; numberOfProblem < 512; numberOfProblem = (int)((short)(numberOfProblem << 1))) {
            int j = 0;
            int jFirst = 0;
            while (jFirst < 512) {
                int n = jTwiddle;
                jTwiddle = (short)(jTwiddle + 1);
                int omega = (int)source[n];
                for (j = jFirst; j < jFirst + numberOfProblem; j = (int)((short)(j + 1))) {
                    int temporary = (int)destination[j];
                    destination[j] = this.barrett(destination[j + numberOfProblem] + (long)temporary, 4205569, (short)1021, (short)32);
                    destination[j + numberOfProblem] = this.montgomery((long)omega * ((long)(8411138 + temporary) - destination[j + numberOfProblem]), 4205569, 3098553343L);
                }
                jFirst = (short)(j + numberOfProblem);
            }
        }
    }

    private void inverseNumberTheoreticTransform(long[] destination, long[] source, short n, int q, long qInverse, short barrettMultiplication, short barrettDivision) {
        int jTwiddle = 0;
        for (short numberOfProblem = 1; numberOfProblem < n; numberOfProblem = (short)(numberOfProblem << 1)) {
            int temporary;
            int omega;
            short j = 0;
            short jFirst = 0;
            while (jFirst < n) {
                int n2 = jTwiddle;
                jTwiddle = (short)(jTwiddle + 1);
                omega = (int)source[n2];
                for (j = jFirst; j < (short)(jFirst + numberOfProblem); j = (short)(j + 1)) {
                    temporary = (int)destination[j];
                    destination[j] = destination[j + numberOfProblem] + (long)temporary;
                    destination[j + numberOfProblem] = this.montgomery((long)omega * ((long)(q * 2 + temporary) - destination[j + numberOfProblem]), q, qInverse);
                }
                jFirst = (short)(j + numberOfProblem);
            }
            numberOfProblem = (short)(numberOfProblem << 1);
            jFirst = 0;
            while (jFirst < n) {
                int n3 = jTwiddle;
                jTwiddle = (short)(jTwiddle + 1);
                omega = (int)source[n3];
                for (j = jFirst; j < (short)(jFirst + numberOfProblem); j = (short)(j + 1)) {
                    temporary = (int)destination[j];
                    if (q == 4206593 || q == 8404993) {
                        destination[j] = this.barrett(destination[j + numberOfProblem] + (long)temporary, q, barrettMultiplication, barrettDivision);
                    }
                    if (q == 485978113) {
                        destination[j] = this.barrettP(destination[j + numberOfProblem] + (long)temporary, q, barrettMultiplication, barrettDivision);
                    }
                    destination[j + numberOfProblem] = this.montgomery((long)omega * ((long)(q * 2 + temporary) - destination[j + numberOfProblem]), q, qInverse);
                }
                jFirst = (short)(j + numberOfProblem);
            }
        }
    }

    private void inverseNumberTheoreticTransformIIIP(long[] destination, long[] source) {
        int jTwiddle = 0;
        for (int numberOfProblem = 1; numberOfProblem < 2048; numberOfProblem = (int)((short)(numberOfProblem << 1))) {
            int j = 0;
            int jFirst = 0;
            while (jFirst < 2048) {
                int n = jTwiddle;
                jTwiddle = (short)(jTwiddle + 1);
                int omega = (int)source[n];
                for (j = jFirst; j < jFirst + numberOfProblem; j = (int)((short)(j + 1))) {
                    int temporary = (int)destination[j];
                    destination[j] = this.barrettP(destination[j + numberOfProblem] + (long)temporary, 1129725953, (short)15, (short)34);
                    destination[j + numberOfProblem] = this.barrettP(this.montgomery((long)omega * ((long)(-2035515390 + temporary) - destination[j + numberOfProblem]), 1129725953, 861290495L), 1129725953, (short)15, (short)34);
                }
                jFirst = (short)(j + numberOfProblem);
            }
        }
    }

    private void componentWisePolynomialMultiplication(long[] product, long[] multiplicand, long[] multiplier, short n, int q, long qInverse) {
        for (short i = 0; i < n; i = (short)(i + 1)) {
            product[i] = this.montgomery(multiplicand[i] * multiplier[i], q, qInverse);
        }
    }

    public void polynomialNumberTheoreticTransform(long[] arrayNumberTheoreticTransform, long[] array, short n, long[] zeta) {
        for (short i = 0; i < n; i = (short)(i + 1)) {
            arrayNumberTheoreticTransform[i] = array[i];
        }
        this.numberTheoreticTransform(arrayNumberTheoreticTransform, zeta);
    }

    public void polynomialMultiplication(long[] product, long[] multiplicand, long[] multiplier, short n, int q, long qInverse, long[] zeta) {
        long[] multiplierNumberTheoreticTransform = new long[n];
        for (short i = 0; i < n; i = (short)(i + 1)) {
            multiplierNumberTheoreticTransform[i] = multiplier[i];
        }
        this.numberTheoreticTransform(multiplierNumberTheoreticTransform, zeta, n, q, qInverse);
        this.componentWisePolynomialMultiplication(product, multiplicand, multiplierNumberTheoreticTransform, n, q, qInverse);
        if (q == 4205569) {
            this.inverseNumberTheoreticTransformI(product, PolynomialHeuristic.ZETA_INVERSE_I);
        }
        if (q == 4206593) {
            this.inverseNumberTheoreticTransform(product, PolynomialHeuristic.ZETA_III_SIZE, (short)1024, 4206593, 4148178943L, (short)1021, (short)32);
        }
        if (q == 8404993) {
            this.inverseNumberTheoreticTransform(product, PolynomialHeuristic.ZETA_III_SPEED, (short)1024, 8404993, 4034936831L, (short)511, (short)32);
        }
    }

    public void polynomialMultiplication(long[] product, long[] multiplicand, long[] multiplier, short n, int q, long qInverse) {
        this.componentWisePolynomialMultiplication(product, multiplicand, multiplier, n, q, qInverse);
        if (q == 485978113) {
            this.inverseNumberTheoreticTransform(product, PolynomialProvablySecure.ZETA_INVERSE_I_P, (short)1024, 485978113, 3421990911L, (short)1, (short)29);
        }
        if (q == 1129725953) {
            this.inverseNumberTheoreticTransformIIIP(product, PolynomialProvablySecure.ZETA_INVERSE_III_P);
        }
    }

    public void polynomialAddition(long[] summation, long[] augend, long[] addend, short n) {
        for (short i = 0; i < n; i = (short)(i + 1)) {
            summation[i] = augend[i] + addend[i];
        }
    }

    public void polynomialSubtraction(long[] difference, long[] minuend, long[] subtrahend, short n, int q, short barrettMultiplication, short barrettDivision) {
        for (short i = 0; i < n; i = (short)(i + 1)) {
            difference[i] = this.barrett((long)(q * 2) + minuend[i] - subtrahend[i], q, barrettMultiplication, barrettDivision);
        }
    }

    public void polynomialSubtractionP(long[] difference, long[] minuend, long[] subtrahend, short n, int q, short barrettMultiplication, short barrettDivision) {
        for (short i = 0; i < n; i = (short)(i + 1)) {
            difference[i] = this.barrettP(minuend[i] - subtrahend[i], q, barrettMultiplication, barrettDivision);
        }
    }

    public void polynomialUniform(long[] A, byte[] seed, int seedOffset, short n, short k, int q, long qInverse, short qLogarithm, short generatorA, int inverseNumberTheoreticTransform) {
        int position = 0;
        int i = 0;
        short numberOfByte = (short)((qLogarithm + 7) / 8);
        short numberOfBlock = generatorA;
        short dualModeSampler = 0;
        int mask = (1 << qLogarithm) - 1;
        short bufferOffset = 0;
        byte[] buffer = new byte[168 * numberOfBlock];
        short s = dualModeSampler;
        dualModeSampler = (short)(dualModeSampler + 1);
        this.fips.customizableSecureHashAlgorithmKECCAK128Simple(buffer, bufferOffset, (short)(168 * numberOfBlock), s, seed, seedOffset, 32);
        while (i < n * k) {
            int value1 = this.function.load32(buffer, position) & mask;
            position = (short)(position + numberOfByte);
            int value2 = this.function.load32(buffer, position) & mask;
            position = (short)(position + numberOfByte);
            int value3 = this.function.load32(buffer, position) & mask;
            position = (short)(position + numberOfByte);
            int value4 = this.function.load32(buffer, position) & mask;
            position = (short)(position + numberOfByte);
            if (value1 < q && i < n * k) {
                A[i++] = this.montgomery((long)value1 * (long)inverseNumberTheoreticTransform, q, qInverse);
            }
            if (value2 < q && i < n * k) {
                A[i++] = this.montgomery((long)value2 * (long)inverseNumberTheoreticTransform, q, qInverse);
            }
            if (value3 < q && i < n * k) {
                A[i++] = this.montgomery((long)value3 * (long)inverseNumberTheoreticTransform, q, qInverse);
            }
            if (value4 < q && i < n * k) {
                A[i++] = this.montgomery((long)value4 * (long)inverseNumberTheoreticTransform, q, qInverse);
            }
            if (position <= 168 * numberOfBlock - 4 * numberOfByte) continue;
            numberOfBlock = 1;
            short s2 = dualModeSampler;
            dualModeSampler = (short)(dualModeSampler + 1);
            this.fips.customizableSecureHashAlgorithmKECCAK128Simple(buffer, bufferOffset, (short)(168 * numberOfBlock), s2, seed, seedOffset, 32);
            position = 0;
        }
    }
}

