/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.maintree;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.subshare.core.server.Server;
import org.subshare.core.server.ServerRegistry;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.ls.ServerRegistryLs;
import org.subshare.gui.maintree.MainTreeItem;
import org.subshare.gui.maintree.ServerMainTreeItem;
import org.subshare.gui.serverlist.ServerListPane;

public class ServerListMainTreeItem
extends MainTreeItem<String> {
    private static final Image icon = new Image(ServerListMainTreeItem.class.getResource("server-list_16x16.png").toExternalForm());
    private ServerRegistry serverRegistry;
    private PropertyChangeListener serversPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            final LinkedHashSet servers = new LinkedHashSet((List)evt.getNewValue());
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ServerListMainTreeItem.this.addOrRemoveTreeItemsViewCallback(servers);
                }
            });
        }
    };

    public ServerListMainTreeItem() {
        super("Servers");
        this.setGraphic((Node)new ImageView(icon));
        new Service<List<Server>>(){

            protected Task<List<Server>> createTask() {
                return new SsTask<List<Server>>(){

                    protected List<Server> call() throws Exception {
                        return ServerListMainTreeItem.this.getServerRegistry().getServers();
                    }

                    protected void succeeded() {
                        List servers;
                        try {
                            servers = (List)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        ServerListMainTreeItem.this.addTreeItemsViewCallback(servers);
                        super.succeeded();
                    }
                };
            }
        }.start();
    }

    protected synchronized ServerRegistry getServerRegistry() {
        if (this.serverRegistry == null) {
            this.serverRegistry = ServerRegistryLs.getServerRegistry();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.serverRegistry, (PropertyBase)ServerRegistry.PropertyEnum.servers, (PropertyChangeListener)this.serversPropertyChangeListener);
        }
        return this.serverRegistry;
    }

    protected void addOrRemoveTreeItemsViewCallback(Set<Server> servers) {
        ServerMainTreeItem smti;
        Objects.requireNonNull(servers, "servers");
        HashMap<Server, ServerMainTreeItem> viewServer2ServerMainTreeItem = new HashMap<Server, ServerMainTreeItem>();
        for (TreeItem ti : this.getChildren()) {
            smti = (ServerMainTreeItem)ti;
            viewServer2ServerMainTreeItem.put((Server)smti.getValueObject(), smti);
        }
        for (Server server : servers) {
            if (viewServer2ServerMainTreeItem.containsKey(server)) continue;
            smti = new ServerMainTreeItem(server);
            viewServer2ServerMainTreeItem.put(server, smti);
            this.getChildren().add((Object)smti);
        }
        if (servers.size() < viewServer2ServerMainTreeItem.size()) {
            for (Server server : servers) {
                viewServer2ServerMainTreeItem.remove(server);
            }
            for (ServerMainTreeItem smti2 : viewServer2ServerMainTreeItem.values()) {
                this.getChildren().remove((Object)smti2);
            }
        }
    }

    private void addTreeItemsViewCallback(Collection<Server> servers) {
        Objects.requireNonNull(servers, "servers");
        for (Server server : servers) {
            this.getChildren().add((Object)new ServerMainTreeItem(server));
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    protected Parent createMainDetailContent() {
        return new ServerListPane();
    }
}

