/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.serverrepo;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import java.util.Objects;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.core.server.Server;
import org.subshare.gui.checkout.CheckOutWizard;
import org.subshare.gui.ls.LocalRepoManagerFactoryLs;
import org.subshare.gui.ls.MetaOnlyRepoManagerLs;
import org.subshare.gui.ls.MetaOnlyRepoSyncDaemonLs;
import org.subshare.gui.util.FxmlUtil;

public class ServerRepoPane
extends GridPane {
    private final Server server;
    private final ServerRepo serverRepo;
    @FXML
    private TextField nameTextField;
    private final StringProperty nameProperty;

    public ServerRepoPane(Server server, ServerRepo serverRepo) {
        this.server = Objects.requireNonNull(server, "server");
        this.serverRepo = Objects.requireNonNull(serverRepo, "serverRepo");
        FxmlUtil.loadDynamicComponentFxml(ServerRepoPane.class, this);
        try {
            this.nameProperty = new JavaBeanStringPropertyBuilder().bean((Object)serverRepo).name(ServerRepo.PropertyEnum.name.name()).build();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.nameTextField.textProperty().bindBidirectional((Property)this.nameProperty);
    }

    @FXML
    private void checkOutButtonClicked(ActionEvent event) {
        new CheckOutWizard(this.server, this.serverRepo).checkOut(this.getScene().getWindow());
    }

    @FXML
    private void redownMetaButtonClicked(ActionEvent event) {
        try (LocalRepoManager localRepoManager = this.createLocalRepoManager();){
            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
            localRepoMetaData.resetLastCryptoKeySyncFromRemoteRepoRemoteRepositoryRevisionSynced();
        }
        MetaOnlyRepoSyncDaemonLs.getMetaOnlyRepoSyncDaemon().sync();
    }

    private LocalRepoManager createLocalRepoManager() {
        File localRoot = MetaOnlyRepoManagerLs.getMetaOnlyRepoManager().getLocalRoot(this.serverRepo);
        return LocalRepoManagerFactoryLs.getLocalRepoManagerFactory().createLocalRepoManagerForExistingRepository(localRoot);
    }
}

