/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.repo.local.AbstractLocalRepoTransactionListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.jdo.FetchPlan;
import javax.jdo.PersistenceManager;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.DuplicateCryptoRepoFileHandler;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;

public class AssignCryptoRepoFileRepoFileListener
extends AbstractLocalRepoTransactionListener
implements StoreLifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(AssignCryptoRepoFileRepoFileListener.class);
    private final Map<String, RepoFile> repoFileName2RepoFile = new HashMap<String, RepoFile>();
    private boolean cryptoRepoFilePersisted;
    private boolean histoCryptoRepoFilePersisted;
    private boolean disabled;
    private boolean forced;

    public void onBegin() {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        PersistenceManager pm = ((ContextWithPersistenceManager)tx).getPersistenceManager();
        pm.addInstanceLifecycleListener((InstanceLifecycleListener)this, new Class[]{RepoFile.class, CryptoRepoFile.class, HistoCryptoRepoFile.class});
    }

    public void preStore(InstanceLifecycleEvent event) {
    }

    public void postStore(InstanceLifecycleEvent event) {
        if (this.disabled || this.forced) {
            return;
        }
        Object persistable = Objects.requireNonNull(event.getPersistentInstance(), "event.persistentInstance");
        if (persistable instanceof RepoFile) {
            RepoFile repoFile = (RepoFile)persistable;
            this.repoFileName2RepoFile.put(Objects.requireNonNull(repoFile.getName(), "repoFile.name"), repoFile);
        } else if (persistable instanceof CryptoRepoFile) {
            this.cryptoRepoFilePersisted = true;
        } else if (persistable instanceof HistoCryptoRepoFile) {
            this.histoCryptoRepoFilePersisted = true;
        }
    }

    public void onCommit() {
        if (this.disabled) {
            return;
        }
        if (!this.forced && this.repoFileName2RepoFile.isEmpty() && !this.cryptoRepoFilePersisted && !this.histoCryptoRepoFilePersisted) {
            return;
        }
        LocalRepoTransaction tx = this.getTransactionOrFail();
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)tx.getDao(CryptoRepoFileDao.class));
        FetchPlan fetchPlan = cryptoRepoFileDao.getPersistenceManager().getFetchPlan();
        fetchPlan.setGroups(new String[]{"default", "CryptoRepoFile.parent"});
        fetchPlan.setMaxFetchDepth(1);
        boolean needFullAssociationAlgorithm = true;
        if (!(this.forced || this.cryptoRepoFilePersisted || this.histoCryptoRepoFilePersisted)) {
            needFullAssociationAlgorithm = false;
            for (RepoFile repoFile : this.repoFileName2RepoFile.values()) {
                CryptoRepoFile cryptoRepoFile = this.associateRepoFileViaCryptoRepoFileLocalName(repoFile);
                if (cryptoRepoFile != null) continue;
                needFullAssociationAlgorithm = true;
                break;
            }
        }
        if (needFullAssociationAlgorithm) {
            Collection<CryptoRepoFile> cryptoRepoFiles = cryptoRepoFileDao.getCryptoRepoFilesWithoutRepoFileAndNotDeleted();
            fetchPlan.setGroup("default");
            for (CryptoRepoFile cryptoRepoFile : cryptoRepoFiles) {
                RepoFile repoFile;
                if (cryptoRepoFile.getLocalName() != null) {
                    repoFile = this.associateRepoFileViaCryptoRepoFileLocalName(cryptoRepoFile);
                    continue;
                }
                repoFile = this.repoFileName2RepoFile.get(cryptoRepoFile.getCryptoRepoFileId().toString());
                if (repoFile == null) continue;
                cryptoRepoFile.setRepoFile(repoFile);
                tx.flush();
            }
        }
        this.repoFileName2RepoFile.clear();
        this.cryptoRepoFilePersisted = false;
        this.histoCryptoRepoFilePersisted = false;
    }

    private CryptoRepoFile associateRepoFileViaCryptoRepoFileLocalName(RepoFile repoFile) {
        Objects.requireNonNull(repoFile, "repoFile");
        LocalRepoTransaction tx = this.getTransactionOrFail();
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)tx.getDao(CryptoRepoFileDao.class));
        CryptoRepoFile cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFile(repoFile);
        if (cryptoRepoFile != null) {
            return cryptoRepoFile;
        }
        RepoFile parentRepoFile = repoFile.getParent();
        if (parentRepoFile == null) {
            logger.trace("repoFile.parent == null, but no CryptoRepoFile associated! {}", (Object)repoFile);
            return null;
        }
        CryptoRepoFile parentCryptoRepoFile = this.associateRepoFileViaCryptoRepoFileLocalName(parentRepoFile);
        if (parentCryptoRepoFile == null) {
            logger.trace("Could not associate CryptoRepoFile to parent! repoFile={} repoFile.parent={}", (Object)repoFile, (Object)parentRepoFile);
            return null;
        }
        String localName = Objects.requireNonNull(repoFile.getName(), "repoFile.name");
        cryptoRepoFile = cryptoRepoFileDao.getChildCryptoRepoFile(parentCryptoRepoFile, localName);
        if (cryptoRepoFile == null) {
            logger.trace("Could not associate CryptoRepoFile to repoFile! repoFile={} repoFile.parent={}", (Object)repoFile, (Object)parentRepoFile);
            return null;
        }
        DuplicateCryptoRepoFileHandler.createInstance(tx).associateCryptoRepoFileWithRepoFile(repoFile, cryptoRepoFile);
        tx.flush();
        return cryptoRepoFile;
    }

    private RepoFile associateRepoFileViaCryptoRepoFileLocalName(CryptoRepoFile cryptoRepoFile) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        RepoFile repoFile = cryptoRepoFile.getRepoFile();
        if (repoFile == null) {
            String localName;
            CryptoRepoFile parentCryptoRepoFile = cryptoRepoFile.getParent();
            LocalRepoTransaction tx = this.getTransactionOrFail();
            if (parentCryptoRepoFile != null && (localName = cryptoRepoFile.getLocalName()) != null) {
                RepoFile parentRepoFile = this.associateRepoFileViaCryptoRepoFileLocalName(parentCryptoRepoFile);
                if (parentRepoFile == null) {
                    return null;
                }
                repoFile = ((RepoFileDao)tx.getDao(RepoFileDao.class)).getChildRepoFile(parentRepoFile, localName);
            }
            if (repoFile != null) {
                DuplicateCryptoRepoFileHandler.createInstance(tx).associateCryptoRepoFileWithRepoFile(repoFile, cryptoRepoFile);
                tx.flush();
            }
        }
        return repoFile;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }
}

