/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.repo.local.CollisionFilter;
import org.subshare.local.persistence.Collision;
import org.subshare.local.persistence.CollisionPrivate;
import org.subshare.local.persistence.CollisionPrivateDao;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.SsRemoteRepository;
import org.subshare.local.persistence.SsRemoteRepositoryDao;

public class CollisionDao
extends Dao<Collision, CollisionDao> {
    private static final Logger logger = LoggerFactory.getLogger(CollisionDao.class);

    public Collision getCollisionOrFail(Uid collisionId) {
        Collision collision = this.getCollision(collisionId);
        Objects.requireNonNull(collision, "getCollision(" + collisionId + ")");
        return collision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collision getCollision(Uid collisionId) {
        Objects.requireNonNull(collisionId, "collisionId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCollision_collisionId");
        try {
            Collision result;
            Collision collision = result = (Collision)((Object)query.execute((Object)collisionId.toString()));
            return collision;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Collision> getCollisionsSignedBetween(Date fromIncl, Date toExcl) {
        Objects.requireNonNull(fromIncl, "fromIncl");
        Objects.requireNonNull(toExcl, "toExcl");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCollisionsSignedBetween_fromIncl_toExcl");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)fromIncl, (Object)toExcl);
            logger.debug("getCollisionsSignedBetween: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getCollisionsSignedBetween: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collision getCollision(HistoCryptoRepoFile histoCryptoRepoFile1, HistoCryptoRepoFile histoCryptoRepoFile2) {
        Objects.requireNonNull(histoCryptoRepoFile1, "histoCryptoRepoFile1");
        Objects.requireNonNull(histoCryptoRepoFile2, "histoCryptoRepoFile2");
        HashMap<String, HistoCryptoRepoFile> params = new HashMap<String, HistoCryptoRepoFile>();
        params.put("histoCryptoRepoFile1", Objects.requireNonNull(histoCryptoRepoFile1, "histoCryptoRepoFile1"));
        params.put("histoCryptoRepoFile2", Objects.requireNonNull(histoCryptoRepoFile2, "histoCryptoRepoFile2"));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCollision_histoCryptoRepoFile1_histoCryptoRepoFile2");
        try {
            Collision result;
            Collision collision = result = (Collision)((Object)query.executeWithMap(params));
            return collision;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collision getCollisionWithDuplicateCryptoRepoFileId(HistoCryptoRepoFile histoCryptoRepoFile1, Uid duplicateCryptoRepoFileId) {
        Objects.requireNonNull(histoCryptoRepoFile1, "histoCryptoRepoFile1");
        Objects.requireNonNull(duplicateCryptoRepoFileId, "duplicateCryptoRepoFileId");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("histoCryptoRepoFile1", (Object)Objects.requireNonNull(histoCryptoRepoFile1, "histoCryptoRepoFile1"));
        params.put("duplicateCryptoRepoFileId", Objects.requireNonNull(duplicateCryptoRepoFileId, "duplicateCryptoRepoFileId").toString());
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCollision_histoCryptoRepoFile1_duplicateCryptoRepoFileId");
        try {
            Collision result;
            Collision collision = result = (Collision)((Object)query.executeWithMap(params));
            return collision;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Collision> getCollisionsWithDuplicateCryptoRepoFileId(Uid cryptoRepoFileId) {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCollisions_duplicateCryptoRepoFileId");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)cryptoRepoFileId.toString());
            logger.debug("getCollisionsWithDuplicateCryptoRepoFileId: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getCollisionsWithDuplicateCryptoRepoFileId: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public Collision getCollision(HistoCryptoRepoFile histoCryptoRepoFile1, HistoCryptoRepoFile histoCryptoRepoFile2, Uid duplicateCryptoRepoFileId) {
        Objects.requireNonNull(histoCryptoRepoFile1, "histoCryptoRepoFile1");
        if (duplicateCryptoRepoFileId != null) {
            return this.getCollisionWithDuplicateCryptoRepoFileId(histoCryptoRepoFile1, duplicateCryptoRepoFileId);
        }
        return this.getCollision(histoCryptoRepoFile1, histoCryptoRepoFile2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Collision> getCollisionsChangedAfter(long localRevision) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCollisionsChangedAfter_localRevision");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision);
            logger.debug("getCollisionsChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getCollisionsChangedAfter: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Collision> getCollisions(CollisionFilter filter) {
        Objects.requireNonNull(filter, "filter");
        filter = this.prepareFilter(filter);
        if (filter == null) {
            return new HashSet<Collision>();
        }
        Query query = this.pm().newQuery(Collision.class);
        try {
            StringBuilder qf = new StringBuilder();
            HashMap<String, Object> qp = new HashMap<String, Object>();
            HashMap qv = new HashMap();
            CollisionDao.appendToQueryFilter_collisionIds(qf, qp, qv, filter.getCollisionIds());
            CollisionDao.appendToQueryFilter_histoCryptoRepoFileId(qf, qp, qv, filter.getHistoCryptoRepoFileId());
            if (filter.isIncludeChildrenRecursively()) {
                CollisionDao.appendToQueryFilter_cryptoRepoFileId_recursive(qf, qp, qv, filter.getCryptoRepoFileId());
            } else {
                CollisionDao.appendToQueryFilter_cryptoRepoFileId_nonRecursive(qf, qp, qv, filter.getCryptoRepoFileId());
            }
            if (qf.length() > 0) {
                query.setFilter(qf.toString());
            }
            if (!qv.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry me : qv.entrySet()) {
                    sb.append(((Class)me.getValue()).getName()).append(' ').append((String)me.getKey()).append(';');
                }
                query.declareVariables(sb.toString());
            }
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.executeWithMap(qp);
            logger.info("getCollisions: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.info("getCollisions: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    private CollisionFilter prepareFilter(CollisionFilter filter) {
        Objects.requireNonNull(filter, "filter");
        if (filter.getLocalPath() != null && filter.getCryptoRepoFileId() != null) {
            throw new IllegalArgumentException("filter.localPath and filter.cryptoRepoFileId must not both be set! Exactly one of them!");
        }
        if (filter.getLocalPath() != null) {
            if ((filter = filter.clone()).getCryptoRepoFileId() != null) {
                throw new IllegalArgumentException("filter.localPath and filter.cryptoRepoFileId must not both be set! Exactly one of them!");
            }
            CryptoRepoFile filterCryptoRepoFile = this.getCryptoRepoFileForLocalPath(filter.getLocalPath());
            if (filterCryptoRepoFile == null) {
                return null;
            }
            filter.setLocalPath(null);
            filter.setCryptoRepoFileId(filterCryptoRepoFile.getCryptoRepoFileId());
        }
        return filter;
    }

    private static void appendToQueryFilter_collisionIds(StringBuilder qf, Map<String, Object> qp, Map<String, Class<?>> qv, Set<Uid> collisionIds) {
        Objects.requireNonNull(qf, "qf");
        Objects.requireNonNull(qp, "qp");
        if (collisionIds == null) {
            return;
        }
        HashSet<String> collisionIdsAsString = new HashSet<String>(collisionIds.size());
        for (Uid collisionId : collisionIds) {
            collisionIdsAsString.add(collisionId.toString());
        }
        CollisionDao.appendAndIfNeeded(qf);
        qf.append(" :collisionIds.contains(this.collisionId) ");
        qp.put("collisionIds", collisionIdsAsString);
    }

    private static void appendToQueryFilter_histoCryptoRepoFileId(StringBuilder qf, Map<String, Object> qp, Map<String, Class<?>> qv, Uid histoCryptoRepoFileId) {
        Objects.requireNonNull(qf, "qf");
        Objects.requireNonNull(qp, "qp");
        if (histoCryptoRepoFileId == null) {
            return;
        }
        CollisionDao.appendAndIfNeeded(qf);
        qf.append(" (").append("  this.histoCryptoRepoFile1.histoCryptoRepoFileId == :histoCryptoRepoFileId").append("  || this.histoCryptoRepoFile2.histoCryptoRepoFileId == :histoCryptoRepoFileId").append(") ");
        qp.put("histoCryptoRepoFileId", histoCryptoRepoFileId.toString());
    }

    private static void appendToQueryFilter_cryptoRepoFileId_nonRecursive(StringBuilder qf, Map<String, Object> qp, Map<String, Class<?>> qv, Uid cryptoRepoFileId) {
        Objects.requireNonNull(qf, "qf");
        Objects.requireNonNull(qp, "qp");
        Objects.requireNonNull(qv, "qv");
        if (cryptoRepoFileId == null) {
            return;
        }
        CollisionDao.appendAndIfNeeded(qf);
        qf.append(" (").append("  this.histoCryptoRepoFile1.cryptoRepoFile.cryptoRepoFileId == :cryptoRepoFileId").append("  || this.histoCryptoRepoFile2.cryptoRepoFile.cryptoRepoFileId == :cryptoRepoFileId").append(") ");
        qp.put("cryptoRepoFileId", cryptoRepoFileId.toString());
    }

    private static void appendToQueryFilter_cryptoRepoFileId_recursive(StringBuilder qf, Map<String, Object> qp, Map<String, Class<?>> qv, Uid cryptoRepoFileId) {
        Objects.requireNonNull(qf, "qf");
        Objects.requireNonNull(qp, "qp");
        Objects.requireNonNull(qv, "qv");
        if (cryptoRepoFileId == null) {
            return;
        }
        CollisionDao.appendAndIfNeeded(qf);
        qf.append(" ( this.cryptoRepoFilePath.contains(crf) && crf.cryptoRepoFileId == :cryptoRepoFileId ) ");
        qv.put("crf", CryptoRepoFile.class);
        qp.put("cryptoRepoFileId", cryptoRepoFileId.toString());
    }

    private CryptoRepoFile getCryptoRepoFileForLocalPath(String localPath) {
        if (localPath == null) {
            return null;
        }
        SsRemoteRepository remoteRepository = ((SsRemoteRepositoryDao)this.getDao(SsRemoteRepositoryDao.class)).getUniqueRemoteRepository();
        if (remoteRepository == null) {
            return null;
        }
        CryptoRepoFile crf1 = ((CryptoRepoFileDao)this.getDao(CryptoRepoFileDao.class)).getCryptoRepoFile(remoteRepository, localPath);
        return crf1;
    }

    private static void appendAndIfNeeded(StringBuilder qf) {
        Objects.requireNonNull(qf, "qf");
        if (qf.length() > 0) {
            qf.append(" && ");
        }
    }

    public void deletePersistent(Collision entity) {
        Objects.requireNonNull(entity, "entity");
        CollisionPrivateDao cpDao = (CollisionPrivateDao)this.getDao(CollisionPrivateDao.class);
        CollisionPrivate collisionPrivate = cpDao.getCollisionPrivate(entity);
        if (collisionPrivate != null) {
            cpDao.deletePersistent(collisionPrivate);
            this.pm().flush();
        }
        super.deletePersistent((Entity)entity);
    }

    public void deletePersistentAll(Collection<? extends Collision> entities) {
        Objects.requireNonNull(entities, "entities");
        CollisionPrivateDao cpDao = (CollisionPrivateDao)this.getDao(CollisionPrivateDao.class);
        for (Collision collision : entities) {
            CollisionPrivate collisionPrivate = cpDao.getCollisionPrivate(collision);
            if (collisionPrivate == null) continue;
            cpDao.deletePersistent(collisionPrivate);
        }
        this.pm().flush();
        super.deletePersistentAll(entities);
    }
}

