/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.repo.local.AbstractLocalRepoTransactionListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import javax.jdo.PersistenceManager;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import org.subshare.local.persistence.FileChunkPayload;
import org.subshare.local.persistence.FileChunkPayloadDao;
import org.subshare.local.persistence.HistoFileChunkDao;
import org.subshare.local.persistence.TempFileChunk;

public class DeleteTempFileChunkListener
extends AbstractLocalRepoTransactionListener
implements DeleteLifecycleListener {
    public void onBegin() {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        PersistenceManager pm = ((ContextWithPersistenceManager)tx).getPersistenceManager();
        pm.addInstanceLifecycleListener((InstanceLifecycleListener)this, new Class[]{TempFileChunk.class});
    }

    public void preDelete(InstanceLifecycleEvent event) {
        TempFileChunk tempFileChunk = (TempFileChunk)((Object)event.getPersistentInstance());
        LocalRepoTransaction tx = this.getTransactionOrFail();
        FileChunkPayloadDao fileChunkPayloadDao = (FileChunkPayloadDao)((Object)tx.getDao(FileChunkPayloadDao.class));
        FileChunkPayload fileChunkPayload = fileChunkPayloadDao.getFileChunkPayload(tempFileChunk);
        if (fileChunkPayload != null) {
            long histoFileChunkCount = ((HistoFileChunkDao)((Object)tx.getDao(HistoFileChunkDao.class))).getHistoFileChunkCount(fileChunkPayload);
            if (histoFileChunkCount == 0L) {
                fileChunkPayloadDao.deletePersistent(fileChunkPayload);
            } else {
                fileChunkPayload.setTempFileChunk(null);
            }
        }
        tx.flush();
    }

    public void postDelete(InstanceLifecycleEvent event) {
    }
}

