/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.inmemory.method;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.query.inmemory.InvocationEvaluator;
import org.datanucleus.util.Localiser;

public class TemporalSecondMethod
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        if (invokedValue == null && expr.getArguments() != null) {
            List<Expression> argExprs = expr.getArguments();
            if (argExprs.size() > 1) {
                throw new NucleusUserException("Incorrect number of arguments to SECOND");
            }
            Expression argExpr = argExprs.get(0);
            invokedValue = eval.getValueForExpression(argExpr);
        }
        if (invokedValue == null) {
            return Boolean.FALSE;
        }
        if (!(invokedValue instanceof Date)) {
            throw new NucleusException(Localiser.msg("021011", expr.getOperation(), invokedValue.getClass().getName()));
        }
        if (invokedValue instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)invokedValue);
            return cal.get(13);
        }
        if (invokedValue instanceof Calendar) {
            return ((Calendar)invokedValue).get(13);
        }
        if (invokedValue instanceof LocalTime) {
            return ((LocalTime)invokedValue).getSecond();
        }
        if (invokedValue instanceof LocalDateTime) {
            return ((LocalDateTime)invokedValue).getSecond();
        }
        throw new NucleusUserException("We do not currently support SECOND() with argument of type " + invokedValue.getClass().getName());
    }
}

