/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.histo.exp;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import java.util.Objects;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.histo.ExportFileParam;
import org.subshare.core.repo.histo.HistoExporter;
import org.subshare.gui.histo.exp.ExportFromHistoryData;
import org.subshare.gui.histo.exp.Messages;
import org.subshare.gui.histo.exp.destination.ExportFromHistoryDestinationWizardPage;
import org.subshare.gui.ls.HistoExporterLs;
import org.subshare.gui.wizard.Wizard;

public class ExportFromHistoryWizard
extends Wizard {
    private final ExportFromHistoryData exportFromHistoryData;

    public ExportFromHistoryWizard(ExportFromHistoryData exportFromHistoryData) {
        this.exportFromHistoryData = Objects.requireNonNull(exportFromHistoryData, "exportFromHistoryData");
        this.setFirstPage(new ExportFromHistoryDestinationWizardPage(exportFromHistoryData));
    }

    @Override
    public String getTitle() {
        return Messages.getString("ExportFromHistoryWizard.title");
    }

    @Override
    protected void finish(ProgressMonitor monitor) throws Exception {
        File exportDirectory = Objects.requireNonNull(this.exportFromHistoryData.getExportDirectory(), "exportFromHistoryData.exportDirectory");
        LocalRepo localRepo = this.exportFromHistoryData.getLocalRepo();
        try (HistoExporter histoExporter = HistoExporterLs.createHistoExporter(localRepo.getLocalRoot());){
            for (Uid histoCryptoRepoFileId : this.exportFromHistoryData.getHistoCryptoRepoFileIds()) {
                histoExporter.exportFile(new ExportFileParam(histoCryptoRepoFileId, exportDirectory));
            }
        }
    }
}

