/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.localrepo.userrepokeylist;

import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.TableView;
import javafx.scene.layout.GridPane;
import org.subshare.core.dto.DebugUserRepoKeyDto;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.listener.LocalRepoCommitEventListener;
import org.subshare.core.repo.listener.LocalRepoCommitEventManager;
import org.subshare.core.repo.listener.WeakLocalRepoCommitEventListener;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.localrepo.userrepokeylist.UserRepoKeyListItem;
import org.subshare.gui.ls.LocalRepoCommitEventManagerLs;
import org.subshare.gui.ls.LocalRepoManagerFactoryLs;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;

public class UserRepoKeyListPane
extends GridPane {
    private LocalRepo localRepo;
    @FXML
    private TableView<UserRepoKeyListItem> tableView;
    private final LocalRepoCommitEventListener localRepoCommitEventListener;
    private WeakLocalRepoCommitEventListener weakLocalRepoCommitEventListener;
    private static final Timer deferredUpdateUiTimer = new Timer(true);
    private TimerTask deferredUpdateUiTimerTask;

    public UserRepoKeyListPane() {
        FxmlUtil.loadDynamicComponentFxml(UserRepoKeyListPane.class, this);
        this.localRepoCommitEventListener = event -> {
            if (!event.getModifications().isEmpty()) {
                this.scheduleDeferredUpdateUiTimerTask();
            }
        };
    }

    private void populateTableViewAsync() {
        if (this.getLocalRepo() == null) {
            return;
        }
        new Service<Collection<DebugUserRepoKeyDto>>(){

            protected Task<Collection<DebugUserRepoKeyDto>> createTask() {
                return new SsTask<Collection<DebugUserRepoKeyDto>>(){

                    protected Collection<DebugUserRepoKeyDto> call() throws Exception {
                        if (UserRepoKeyListPane.this.getLocalRepo() == null) {
                            return Collections.emptyList();
                        }
                        try (LocalRepoManager localRepoManager = UserRepoKeyListPane.this.createLocalRepoManager();){
                            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                            ArrayList<DebugUserRepoKeyDto> arrayList = new ArrayList<DebugUserRepoKeyDto>(localRepoMetaData.getDebugUserRepoKeyDtos());
                            return arrayList;
                        }
                    }

                    protected void succeeded() {
                        Collection dtos;
                        try {
                            dtos = (Collection)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        UserRepoKeyListPane.this.addOrRemoveTableItemsViewCallback(dtos);
                    }
                };
            }
        }.start();
    }

    private synchronized void scheduleDeferredUpdateUiTimerTask() {
        if (this.deferredUpdateUiTimerTask != null) {
            this.deferredUpdateUiTimerTask.cancel();
            this.deferredUpdateUiTimerTask = null;
        }
        this.deferredUpdateUiTimerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UserRepoKeyListPane userRepoKeyListPane = UserRepoKeyListPane.this;
                synchronized (userRepoKeyListPane) {
                    UserRepoKeyListPane.this.deferredUpdateUiTimerTask = null;
                }
                Platform.runLater(() -> UserRepoKeyListPane.this.populateTableViewAsync());
            }
        };
        deferredUpdateUiTimer.schedule(this.deferredUpdateUiTimerTask, 500L);
    }

    public LocalRepo getLocalRepo() {
        return this.localRepo;
    }

    public void setLocalRepo(LocalRepo localRepo) {
        PlatformUtil.assertFxApplicationThread();
        if (Util.equal((Object)this.localRepo, (Object)localRepo)) {
            return;
        }
        if (this.weakLocalRepoCommitEventListener != null) {
            this.weakLocalRepoCommitEventListener.removeLocalRepoCommitEventListener();
            this.weakLocalRepoCommitEventListener = null;
        }
        this.localRepo = localRepo;
        if (localRepo != null) {
            UUID localRepositoryId = localRepo.getRepositoryId();
            LocalRepoCommitEventManager localRepoCommitEventManager = LocalRepoCommitEventManagerLs.getLocalRepoCommitEventManager();
            this.weakLocalRepoCommitEventListener = new WeakLocalRepoCommitEventListener(localRepoCommitEventManager, localRepositoryId, this.localRepoCommitEventListener);
            this.weakLocalRepoCommitEventListener.addLocalRepoCommitEventListener();
        }
        this.populateTableViewAsync();
    }

    private LocalRepoManager createLocalRepoManager() {
        LocalRepo localRepo = Objects.requireNonNull(this.getLocalRepo(), "localRepo");
        return LocalRepoManagerFactoryLs.getLocalRepoManagerFactory().createLocalRepoManagerForExistingRepository(localRepo.getLocalRoot());
    }

    private void addOrRemoveTableItemsViewCallback(Collection<DebugUserRepoKeyDto> dtos) {
        Objects.requireNonNull(dtos, "dtos");
        HashMap<DebugUserRepoKeyDto, UserRepoKeyListItem> viewDto2ListItem = new HashMap<DebugUserRepoKeyDto, UserRepoKeyListItem>();
        for (UserRepoKeyListItem li : this.tableView.getItems()) {
            viewDto2ListItem.put(li.getDebugUserRepoKeyDto(), li);
        }
        for (DebugUserRepoKeyDto dto : dtos) {
            if (viewDto2ListItem.containsKey(dto)) continue;
            UserRepoKeyListItem li = new UserRepoKeyListItem(dto);
            viewDto2ListItem.put(dto, li);
            this.tableView.getItems().add((Object)li);
        }
        if (dtos.size() < viewDto2ListItem.size()) {
            for (DebugUserRepoKeyDto dto : dtos) {
                viewDto2ListItem.remove(dto);
            }
            for (UserRepoKeyListItem li : viewDto2ListItem.values()) {
                this.tableView.getItems().remove((Object)li);
            }
        }
    }
}

