/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.client.ssl;

import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.rest.client.ssl.DynamicX509TrustManager;
import co.codewizards.cloudstore.rest.client.ssl.DynamicX509TrustManagerCallback;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public final class SSLContextBuilder {
    private URL remoteURL;
    private File trustStoreFile;
    private DynamicX509TrustManagerCallback callback;

    private SSLContextBuilder() {
    }

    public static SSLContextBuilder create() {
        return new SSLContextBuilder();
    }

    public DynamicX509TrustManagerCallback getCallback() {
        return this.callback;
    }

    public void setCallback(DynamicX509TrustManagerCallback callback) {
        this.callback = callback;
    }

    public SSLContextBuilder callback(DynamicX509TrustManagerCallback callback) {
        this.setCallback(callback);
        return this;
    }

    public URL getRemoteURL() {
        return this.remoteURL;
    }

    public void setRemoteURL(URL remoteURL) {
        this.remoteURL = remoteURL;
    }

    public SSLContextBuilder remoteURL(URL remoteURL) {
        this.setRemoteURL(remoteURL);
        return this;
    }

    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStoreFile(File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public SSLContextBuilder trustStoreFile(File trustStoreFile) {
        this.setTrustStoreFile(trustStoreFile);
        return this;
    }

    public SSLContext build() throws GeneralSecurityException {
        File trustStoreFile = this.getTrustStoreFile();
        if (trustStoreFile != null) {
            if (this.getRemoteURL() != null) {
                throw new IllegalStateException("remoteURL and trustStoreFile are both set! Only one of these should be set!");
            }
            return this.getSSLContext(trustStoreFile, this.getCallback());
        }
        return this.getSSLContext(this.getRemoteURL(), this.getCallback());
    }

    private SSLContext getSSLContext(File trustStoreFile, DynamicX509TrustManagerCallback callback) throws GeneralSecurityException {
        Objects.requireNonNull(trustStoreFile, "trustStoreFile");
        Objects.requireNonNull(callback, "callback");
        TrustManager[] trustManagers = new TrustManager[]{new DynamicX509TrustManager(trustStoreFile, callback)};
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, trustManagers, null);
        return sslContext;
    }

    private SSLContext getSSLContext(URL remoteURL, DynamicX509TrustManagerCallback callback) throws GeneralSecurityException {
        Objects.requireNonNull(remoteURL, "remoteURL");
        Objects.requireNonNull(callback, "callback");
        String trustStoreFileName = remoteURL.getHost();
        if (remoteURL.getPort() >= 0) {
            trustStoreFileName = trustStoreFileName + "_" + remoteURL.getPort();
        }
        trustStoreFileName = trustStoreFileName + ".truststore";
        File sslClient = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"ssl.client"});
        if (!sslClient.isDirectory()) {
            sslClient.mkdirs();
        }
        if (!sslClient.isDirectory()) {
            throw new IllegalStateException("Could not create directory (permissions?): " + sslClient);
        }
        return this.getSSLContext(OioFileFactory.createFile((File)sslClient, (String[])new String[]{trustStoreFileName}), callback);
    }
}

