/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.config;

import co.codewizards.cloudstore.core.appid.AppIdRegistry;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.core.util.StringUtil;

public class ConfigDir {
    private static final String APP_ID_SIMPLE_ID = AppIdRegistry.getInstance().getAppIdOrFail().getSimpleId();
    public static final String SYSTEM_PROPERTY_CONFIG_DIR = APP_ID_SIMPLE_ID + ".configDir";
    public static final String ENV_VAR_CONFIG_DIR = PropertiesUtil.systemPropertyToEnvironmentVariable(SYSTEM_PROPERTY_CONFIG_DIR);
    public static final String SYSTEM_PROPERTY_LOG_DIR = APP_ID_SIMPLE_ID + ".logDir";
    private final String value;
    private final File file;
    private File logDir;

    protected ConfigDir() {
        String v = System.getProperty(SYSTEM_PROPERTY_CONFIG_DIR);
        if (v == null) {
            v = System.getenv(ENV_VAR_CONFIG_DIR);
        }
        if (v == null) {
            v = "${user.home}/." + APP_ID_SIMPLE_ID;
        }
        this.value = v;
        System.setProperty(SYSTEM_PROPERTY_CONFIG_DIR, this.value);
        String resolvedValue = IOUtil.replaceTemplateVariables(this.value, System.getProperties());
        this.file = OioFileFactory.createFile(resolvedValue).getAbsoluteFile();
        if (!this.file.isDirectory()) {
            this.file.mkdirs();
        }
        if (!this.file.isDirectory()) {
            throw new IllegalStateException("Could not create directory (permissions?!): " + this.file);
        }
    }

    public static ConfigDir getInstance() {
        return ConfigDirHolder.instance;
    }

    public String getValue() {
        return this.value;
    }

    public File getFile() {
        return this.file;
    }

    public File getLogDir() {
        if (this.logDir == null) {
            String sysPropVal = System.getProperty(SYSTEM_PROPERTY_LOG_DIR);
            if (StringUtil.isEmpty(sysPropVal)) {
                this.logDir = OioFileFactory.createFile(this.getFile(), "log");
            } else {
                String resolvedSysPropVal = IOUtil.replaceTemplateVariables(sysPropVal, System.getProperties());
                this.logDir = OioFileFactory.createFile(resolvedSysPropVal).getAbsoluteFile();
            }
            System.setProperty(SYSTEM_PROPERTY_LOG_DIR, this.logDir.getPath());
            if (!this.logDir.isDirectory()) {
                this.logDir.mkdirs();
            }
            if (!this.logDir.isDirectory()) {
                throw new IllegalStateException("Could not create directory (permissions?!): " + this.logDir);
            }
        }
        return this.logDir;
    }

    private static final class ConfigDirHolder {
        public static ConfigDir instance = new ConfigDir();

        private ConfigDirHolder() {
        }
    }
}

