/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import java.util.Objects;

public final class LongUtil {
    private LongUtil() {
    }

    public static final byte[] toBytes(long value) {
        byte[] bytes = new byte[8];
        int idx = -1;
        for (int i = 7; i >= 0; --i) {
            bytes[++idx] = (byte)(value >> 8 * i);
        }
        return bytes;
    }

    public static final long fromBytes(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes");
        long value = 0L;
        int imax = Math.min(8, bytes.length);
        for (int i = 0; i < imax; ++i) {
            value = value << 8 | (long)(bytes[i] & 0xFF);
        }
        return value;
    }

    public static final String[] toBytesHex(long value, boolean withZeroPadding) {
        byte[] bytes = LongUtil.toBytes(value);
        String[] result = new String[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = Integer.toHexString(bytes[i] & 0xFF);
            if (!withZeroPadding || result[i].length() != 1) continue;
            result[i] = '0' + result[i];
        }
        return result;
    }

    public static final long fromBytesHex(String[] bytesHex) {
        Objects.requireNonNull(bytesHex, "bytesHex");
        byte[] bytes = new byte[bytesHex.length];
        for (int i = 0; i < bytesHex.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(bytesHex[i], 16);
        }
        return LongUtil.fromBytes(bytes);
    }
}

