/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.version;

import co.codewizards.cloudstore.core.dto.VersionInfoDto;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.version.ClientTooOldException;
import co.codewizards.cloudstore.core.version.ServerTooOldException;
import co.codewizards.cloudstore.core.version.Version;
import co.codewizards.cloudstore.core.version.VersionCompatibilityException;
import java.util.Objects;

public class VersionCompatibilityValidator {
    protected VersionCompatibilityValidator() {
    }

    public static VersionCompatibilityValidator getInstance() {
        return ObjectFactoryUtil.createObject(VersionCompatibilityValidator.class);
    }

    public void validate(VersionInfoDto clientVersionInfoDto, VersionInfoDto serverVersionInfoDto) throws VersionCompatibilityException {
        Objects.requireNonNull(clientVersionInfoDto, "clientVersionInfoDto");
        Objects.requireNonNull(serverVersionInfoDto, "serverVersionInfoDto");
        Version clientVersion = Objects.requireNonNull(clientVersionInfoDto.getLocalVersion(), "clientVersionInfoDto.localVersion");
        Version minimumServerVersion = Objects.requireNonNull(clientVersionInfoDto.getMinimumRemoteVersion(), "clientVersionInfoDto.minimumRemoteVersion");
        Version serverVersion = Objects.requireNonNull(serverVersionInfoDto.getLocalVersion(), "serverVersionInfoDto.localVersion");
        Version minimumClientVersion = Objects.requireNonNull(serverVersionInfoDto.getMinimumRemoteVersion(), "serverVersionInfoDto.minimumRemoteVersion");
        if (serverVersion.compareTo(minimumServerVersion) < 0) {
            throw new ServerTooOldException(clientVersionInfoDto, serverVersionInfoDto, String.format("The server version is %s, but the client requires at least server version %s!", serverVersion, minimumServerVersion));
        }
        if (clientVersion.compareTo(minimumClientVersion) < 0) {
            throw new ClientTooOldException(clientVersionInfoDto, serverVersionInfoDto, String.format("The client version is %s, but the server requires at least client version %s!", clientVersion, minimumClientVersion));
        }
    }
}

