/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.client;

import co.codewizards.cloudstore.ls.client.LocalServerClient;
import co.codewizards.cloudstore.ls.core.invoke.ObjectManager;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRef;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefConverter;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxy;
import java.util.Objects;

class ObjectRefConverterImpl
implements ObjectRefConverter {
    private final LocalServerClient localServerClient;
    private final ObjectManager objectManager;

    public ObjectRefConverterImpl(LocalServerClient localServerClient) {
        this.localServerClient = Objects.requireNonNull(localServerClient, "localServerClient");
        this.objectManager = Objects.requireNonNull(localServerClient.getObjectManager(), "localServerClient.objectManager");
    }

    public Object convertToObjectRefIfNeeded(Object object) {
        if (object instanceof RemoteObjectProxy) {
            return Objects.requireNonNull(((RemoteObjectProxy)object).getObjectRef(), "object.getObjectRef()");
        }
        return this.objectManager.getObjectRefOrObject(object);
    }

    public Object convertFromObjectRefIfNeeded(Object object) {
        if (object instanceof ObjectRef) {
            ObjectRef objectRef = (ObjectRef)object;
            if (this.objectManager.getClientId().equals((Object)objectRef.getClientId())) {
                return this.objectManager.getObjectOrFail(objectRef);
            }
            return this.localServerClient.getRemoteObjectProxyOrCreate(objectRef);
        }
        return object;
    }
}

