/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchGroups;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@FetchGroups(value={@FetchGroup(name="CryptoKeyDto", members={@Persistent(name="signature")})})
public class CryptoKeyDeactivation
extends Entity
implements WriteProtected,
Persistable {
    @Persistent(mappedBy="cryptoKeyDeactivation", nullValue=NullValue.EXCEPTION)
    private CryptoKey cryptoKey;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final String[] dnFieldNames = CryptoKeyDeactivation.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = CryptoKeyDeactivation.__dnGetInheritedFieldCount();

    public CryptoKey getCryptoKey() {
        return CryptoKeyDeactivation.dnGetcryptoKey(this);
    }

    public void setCryptoKey(CryptoKey cryptoKey) {
        if (!Util.equal((Object)((Object)CryptoKeyDeactivation.dnGetcryptoKey(this)), (Object)((Object)cryptoKey))) {
            CryptoKeyDeactivation.dnSetcryptoKey(this, cryptoKey);
        }
    }

    public String getSignedDataType() {
        return "CryptoKeyDeactivation";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            return InputStreamSource.Helper.createInputStreamSource((Uid)CryptoKeyDeactivation.dnGetcryptoKey(this).getCryptoKeyId()).createInputStream();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return CryptoKeyDeactivation.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)CryptoKeyDeactivation.dnGetsignature(this), (Object)signature)) {
            CryptoKeyDeactivation.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        CryptoKey ck = Objects.requireNonNull(CryptoKeyDeactivation.dnGetcryptoKey(this), "cryptoKey");
        CryptoKeyRole cryptoKeyRole = Objects.requireNonNull(ck.getCryptoKeyRole(), "cryptoKey.cryptoKeyRole");
        CryptoRepoFile cryptoRepoFile = Objects.requireNonNull(ck.getCryptoRepoFile(), "cryptoKey.cryptoRepoFile");
        switch (cryptoKeyRole) {
            case backlinkKey: 
            case dataKey: {
                return null;
            }
        }
        return Objects.requireNonNull(cryptoRepoFile.getCryptoRepoFileId(), "cryptoRepoFile.cryptoRepoFileId");
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.grant;
    }

    static {
        EnhancementHelper.registerClass((Class)CryptoKeyDeactivation.___dn$loadClass("org.subshare.local.persistence.CryptoKeyDeactivation"), (Persistable)new CryptoKeyDeactivation());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        CryptoKeyDeactivation result = new CryptoKeyDeactivation();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        CryptoKeyDeactivation result = new CryptoKeyDeactivation();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoKey = (CryptoKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 1: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoKey);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(CryptoKeyDeactivation obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoKey = obj.cryptoKey;
                break;
            }
            case 1: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof CryptoKeyDeactivation)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.CryptoKeyDeactivation");
        }
        CryptoKeyDeactivation other = (CryptoKeyDeactivation)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"cryptoKey", "signature"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 2 + Entity.dnGetManagedFieldCount();
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static CryptoKey dnGetcryptoKey(CryptoKeyDeactivation objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (CryptoKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoKey));
        }
        return objPC.cryptoKey;
    }

    private static void dnSetcryptoKey(CryptoKeyDeactivation objPC, CryptoKey val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoKey, (Object)val);
        }
    }

    private static SignatureImpl dnGetsignature(CryptoKeyDeactivation objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(CryptoKeyDeactivation objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

