/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.FileChunk;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import java.util.HashMap;
import java.util.Objects;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.persistence.FileChunkPayload;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.TempFileChunk;

public class FileChunkPayloadDao
extends Dao<FileChunkPayload, FileChunkPayloadDao> {
    private static final Logger logger = LoggerFactory.getLogger(FileChunkPayloadDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChunkPayload getFileChunkPayload(TempFileChunk tempFileChunk) {
        Objects.requireNonNull(tempFileChunk, "tempFileChunk");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getFileChunkPayload_tempFileChunk");
        try {
            HashMap<String, TempFileChunk> params = new HashMap<String, TempFileChunk>(1);
            params.put("tempFileChunk", tempFileChunk);
            long startTimestamp = System.currentTimeMillis();
            FileChunkPayload result = (FileChunkPayload)((Object)query.executeWithMap(params));
            logger.debug("getFileChunkPayload(TempFileChunk): query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            FileChunkPayload fileChunkPayload = result;
            return fileChunkPayload;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChunkPayload getFileChunkPayload(FileChunk fileChunk) {
        Objects.requireNonNull(fileChunk, "fileChunk");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getFileChunkPayload_fileChunk");
        try {
            HashMap<String, FileChunk> params = new HashMap<String, FileChunk>(1);
            params.put("fileChunk", fileChunk);
            long startTimestamp = System.currentTimeMillis();
            FileChunkPayload result = (FileChunkPayload)((Object)query.executeWithMap(params));
            logger.debug("getFileChunkPayload(FileChunk): query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            FileChunkPayload fileChunkPayload = result;
            return fileChunkPayload;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChunkPayload getFileChunkPayloadOfFileChunk(NormalFile normalFile, long offset) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getFileChunkPayloadOfFileChunk_normalFile_offset");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("normalFile", normalFile);
            params.put("offset", offset);
            long startTimestamp = System.currentTimeMillis();
            FileChunkPayload result = (FileChunkPayload)((Object)query.executeWithMap(params));
            logger.debug("getFileChunkPayloadOfFileChunk: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            FileChunkPayload fileChunkPayload = result;
            return fileChunkPayload;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChunkPayload getFileChunkPayloadOfHistoFileChunk(HistoCryptoRepoFile histoCryptoRepoFile, long offset) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getFileChunkPayloadOfHistoFileChunk_histoCryptoRepoFile_offset");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("histoCryptoRepoFile", (Object)histoCryptoRepoFile);
            params.put("offset", offset);
            long startTimestamp = System.currentTimeMillis();
            FileChunkPayload result = (FileChunkPayload)((Object)query.executeWithMap(params));
            logger.debug("getFileChunkPayloadOfFileChunk: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            FileChunkPayload fileChunkPayload = result;
            return fileChunkPayload;
        }
        finally {
            query.closeAll();
        }
    }
}

