/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.auth;

import co.codewizards.cloudstore.core.auth.BouncyCastleRegistrationUtil;
import co.codewizards.cloudstore.core.auth.SignedAuthToken;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Objects;

public class AuthTokenSigner {
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private PrivateKey privateKey;

    public AuthTokenSigner(byte[] privateKeyData) {
        Objects.requireNonNull(privateKeyData, "privateKeyData");
        BouncyCastleRegistrationUtil.registerBouncyCastleIfNeeded();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyData);
            this.privateKey = keyFactory.generatePrivate(privateKeySpec);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SignedAuthToken sign(byte[] authTokenData) {
        Objects.requireNonNull(authTokenData, "authTokenData");
        try {
            Signature signingEngine = Signature.getInstance(SIGNATURE_ALGORITHM);
            signingEngine.initSign(this.privateKey);
            signingEngine.update(authTokenData);
            byte[] signature = signingEngine.sign();
            SignedAuthToken signedAuthToken = new SignedAuthToken();
            signedAuthToken.setAuthTokenData(authTokenData);
            signedAuthToken.setSignature(signature);
            return signedAuthToken;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

