/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.auth.AuthToken;
import co.codewizards.cloudstore.core.auth.AuthTokenIO;
import co.codewizards.cloudstore.core.auth.AuthTokenSigner;
import co.codewizards.cloudstore.core.auth.EncryptedSignedAuthToken;
import co.codewizards.cloudstore.core.auth.SignedAuthToken;
import co.codewizards.cloudstore.core.auth.SignedAuthTokenEncrypter;
import co.codewizards.cloudstore.core.auth.SignedAuthTokenIO;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.rest.server.auth.TransientRepoPassword;
import co.codewizards.cloudstore.rest.server.auth.TransientRepoPasswordManager;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="_EncryptedSignedAuthToken/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class EncryptedSignedAuthTokenService {
    private static final Logger logger = LoggerFactory.getLogger(EncryptedSignedAuthTokenService.class);
    @PathParam(value="repositoryName")
    private String repositoryName;

    public EncryptedSignedAuthTokenService() {
        logger.debug("<init>: created new instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{clientRepositoryId}")
    public EncryptedSignedAuthToken getEncryptedSignedAuthToken(@PathParam(value="clientRepositoryId") UUID clientRepositoryId) {
        Objects.requireNonNull(this.repositoryName, "repositoryName");
        Objects.requireNonNull(clientRepositoryId, "clientRepositoryId");
        File localRoot = LocalRepoRegistryImpl.getInstance().getLocalRootForRepositoryNameOrFail(this.repositoryName);
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);){
            EncryptedSignedAuthToken result;
            EncryptedSignedAuthToken encryptedSignedAuthToken = result = this.getEncryptedSignedAuthToken(localRepoManager.getRepositoryId(), clientRepositoryId, localRepoManager.getPrivateKey(), localRepoManager.getRemoteRepositoryPublicKeyOrFail(clientRepositoryId));
            return encryptedSignedAuthToken;
        }
    }

    protected EncryptedSignedAuthToken getEncryptedSignedAuthToken(UUID serverRepositoryId, UUID clientRepositoryId, byte[] localRepoPrivateKey, byte[] remoteRepoPublicKey) {
        TransientRepoPassword transientRepoPassword = TransientRepoPasswordManager.getInstance().getCurrentAuthRepoPassword(serverRepositoryId, clientRepositoryId);
        AuthToken authToken = transientRepoPassword.getAuthToken();
        byte[] authTokenData = new AuthTokenIO().serialise(authToken);
        SignedAuthToken signedAuthToken = new AuthTokenSigner(localRepoPrivateKey).sign(authTokenData);
        byte[] signedAuthTokenData = new SignedAuthTokenIO().serialise(signedAuthToken);
        EncryptedSignedAuthToken encryptedSignedAuthToken = new SignedAuthTokenEncrypter(remoteRepoPublicKey).encrypt(signedAuthTokenData);
        return encryptedSignedAuthToken;
    }
}

