/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.dto.DateTime;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.rest.server.service.AbstractServiceWithRepoToRepoAuth;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="_endPutFile/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class EndPutFileService
extends AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(EndPutFileService.class);

    public EndPutFileService() {
        logger.debug("<init>: created new instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{path:.*}")
    public void endPutFile(@PathParam(value="path") String path, @QueryParam(value="lastModified") DateTime lastModified, @QueryParam(value="length") long length, @QueryParam(value="sha1") String sha1) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(lastModified, "lastModified");
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            path = repoTransport.unprefixPath(path);
            repoTransport.endPutFile(path, lastModified.toDate(), length, sha1);
        }
    }
}

