/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core;

import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServerPropertiesManager {
    private static final Logger logger = LoggerFactory.getLogger(LocalServerPropertiesManager.class);
    public static final String PROPERTY_KEY_PORT = "port";
    public static final String PROPERTY_KEY_PASSWORD = "password";
    private volatile Properties localServerProperties;
    private File localServerPropertiesFile;

    protected LocalServerPropertiesManager() {
    }

    public static LocalServerPropertiesManager getInstance() {
        return Holder.instance;
    }

    protected File getLocalServerPropertiesFile() {
        if (this.localServerPropertiesFile == null) {
            this.localServerPropertiesFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"localServer.properties"});
        }
        return this.localServerPropertiesFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties getLocalServerProperties() {
        Properties properties = this.localServerProperties;
        if (properties != null) return properties;
        properties = new Properties();
        try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getLocalServerPropertiesFile(), 30000L);
             InputStream in = StreamUtil.castStream((IInputStream)lockFile.createInputStream());){
            Properties p = this.localServerProperties;
            if (p != null) {
                Properties properties2 = p;
                return properties2;
            }
            properties.load(in);
            this.localServerProperties = properties;
            return properties;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public void writeLocalServerProperties() {
        Properties properties = this.getLocalServerProperties();
        try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getLocalServerPropertiesFile(), 30000L);
             OutputStream out = StreamUtil.castStream((IOutputStream)lockFile.createOutputStream());){
            properties.store(out, null);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public int getPort() {
        String s = this.getLocalServerProperties().getProperty(PROPERTY_KEY_PORT);
        try {
            int port = Integer.parseInt(s);
            if (port < 1 || port > 65535) {
                throw new NumberFormatException("Port is out of range: " + port);
            }
            return port;
        }
        catch (NumberFormatException x) {
            logger.warn("getPort: " + x, (Throwable)x);
            return -1;
        }
    }

    public void setPort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port is out of range: " + port);
        }
        this.getLocalServerProperties().setProperty(PROPERTY_KEY_PORT, Integer.toString(port));
    }

    public String getBaseUrl() {
        int port = LocalServerPropertiesManager.getInstance().getPort();
        if (port < 0) {
            return null;
        }
        String baseUrl = "http://127.0.0.1:" + port + '/';
        return baseUrl;
    }

    public String getPassword() {
        return this.getLocalServerProperties().getProperty(PROPERTY_KEY_PASSWORD);
    }

    public void setPassword(String password) {
        Objects.requireNonNull(password, PROPERTY_KEY_PASSWORD);
        this.getLocalServerProperties().setProperty(PROPERTY_KEY_PASSWORD, password);
    }

    public void clear() {
        this.localServerProperties = null;
    }

    private static final class Holder {
        public static final LocalServerPropertiesManager instance = new LocalServerPropertiesManager();

        private Holder() {
        }
    }
}

