/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.internal.ServiceFinderBinder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.message.internal.BasicTypesMessageProvider;
import org.glassfish.jersey.message.internal.ByteArrayProvider;
import org.glassfish.jersey.message.internal.CacheControlProvider;
import org.glassfish.jersey.message.internal.CookieProvider;
import org.glassfish.jersey.message.internal.DataSourceProvider;
import org.glassfish.jersey.message.internal.DateProvider;
import org.glassfish.jersey.message.internal.EntityTagProvider;
import org.glassfish.jersey.message.internal.FileProvider;
import org.glassfish.jersey.message.internal.FormMultivaluedMapProvider;
import org.glassfish.jersey.message.internal.FormProvider;
import org.glassfish.jersey.message.internal.InputStreamProvider;
import org.glassfish.jersey.message.internal.LinkProvider;
import org.glassfish.jersey.message.internal.LocaleProvider;
import org.glassfish.jersey.message.internal.MediaTypeProvider;
import org.glassfish.jersey.message.internal.NewCookieProvider;
import org.glassfish.jersey.message.internal.ReaderProvider;
import org.glassfish.jersey.message.internal.RenderedImageProvider;
import org.glassfish.jersey.message.internal.SourceProvider;
import org.glassfish.jersey.message.internal.StreamingOutputProvider;
import org.glassfish.jersey.message.internal.StringHeaderProvider;
import org.glassfish.jersey.message.internal.StringMessageProvider;
import org.glassfish.jersey.message.internal.UriProvider;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

public final class MessagingBinders {
    private MessagingBinders() {
    }

    public static class HeaderDelegateProviders
    extends AbstractBinder {
        private final Set<HeaderDelegateProvider> providers;

        public HeaderDelegateProviders() {
            HashSet<HeaderDelegateProvider> providers = new HashSet<HeaderDelegateProvider>();
            providers.add(new CacheControlProvider());
            providers.add(new CookieProvider());
            providers.add(new DateProvider());
            providers.add(new EntityTagProvider());
            providers.add(new LinkProvider());
            providers.add(new LocaleProvider());
            providers.add(new MediaTypeProvider());
            providers.add(new NewCookieProvider());
            providers.add(new StringHeaderProvider());
            providers.add(new UriProvider());
            this.providers = providers;
        }

        @Override
        protected void configure() {
            this.providers.forEach(provider -> {
                InstanceBinding cfr_ignored_0 = (InstanceBinding)this.bind(provider).to(HeaderDelegateProvider.class);
            });
        }

        public Set<HeaderDelegateProvider> getHeaderDelegateProviders() {
            return this.providers;
        }
    }

    public static class MessageBodyProviders
    extends AbstractBinder {
        private final Map<String, Object> applicationProperties;
        private final RuntimeType runtimeType;

        public MessageBodyProviders(Map<String, Object> applicationProperties, RuntimeType runtimeType) {
            this.applicationProperties = applicationProperties;
            this.runtimeType = runtimeType;
        }

        @Override
        protected void configure() {
            this.bindSingletonWorker(ByteArrayProvider.class);
            this.bindSingletonWorker(DataSourceProvider.class);
            this.bindSingletonWorker(FileProvider.class);
            this.bindSingletonWorker(FormMultivaluedMapProvider.class);
            this.bindSingletonWorker(FormProvider.class);
            this.bindSingletonWorker(InputStreamProvider.class);
            this.bindSingletonWorker(BasicTypesMessageProvider.class);
            this.bindSingletonWorker(ReaderProvider.class);
            this.bindSingletonWorker(RenderedImageProvider.class);
            this.bindSingletonWorker(StringMessageProvider.class);
            ((ClassBinding)this.bind(SourceProvider.StreamSourceReader.class).to(MessageBodyReader.class)).in(Singleton.class);
            ((ClassBinding)this.bind(SourceProvider.SaxSourceReader.class).to(MessageBodyReader.class)).in(Singleton.class);
            ((ClassBinding)this.bind(SourceProvider.DomSourceReader.class).to(MessageBodyReader.class)).in(Singleton.class);
            ((ClassBinding)this.bind(StreamingOutputProvider.class).to(MessageBodyWriter.class)).in(Singleton.class);
            ((ClassBinding)this.bind(SourceProvider.SourceWriter.class).to(MessageBodyWriter.class)).in(Singleton.class);
            this.install(new ServiceFinderBinder<HeaderDelegateProvider>(HeaderDelegateProvider.class, this.applicationProperties, this.runtimeType));
        }

        private <T extends MessageBodyReader & MessageBodyWriter> void bindSingletonWorker(Class<T> worker) {
            ((ClassBinding)((ClassBinding)this.bind(worker).to(MessageBodyReader.class)).to(MessageBodyWriter.class)).in(Singleton.class);
        }
    }
}

