/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.CollectionUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Entity;
import co.codewizards.cloudstore.local.persistence.FetchPlanBackup;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.repo.local.HistoFrameFilter;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.HistoFrame;
import org.subshare.local.persistence.SsRemoteRepository;
import org.subshare.local.persistence.SsRemoteRepositoryDao;

public class HistoFrameDao
extends Dao<HistoFrame, HistoFrameDao> {
    private static final Logger logger = LoggerFactory.getLogger(HistoFrameDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HistoFrame> getHistoFramesChangedAfterExclLastSyncFromRepositoryId(long localRevision, UUID exclLastSyncFromRepositoryId) {
        Objects.requireNonNull(exclLastSyncFromRepositoryId, "exclLastSyncFromRepositoryId");
        PersistenceManager pm = this.pm();
        FetchPlanBackup fetchPlanBackup = FetchPlanBackup.createFrom((PersistenceManager)pm);
        Query query = pm.newNamedQuery(this.getEntityClass(), "getHistoFramesChangedAfter_localRevision_exclLastSyncFromRepositoryId");
        try {
            this.clearFetchGroups();
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision, (Object)exclLastSyncFromRepositoryId.toString());
            logger.debug("getHistoFramesChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            fetchPlanBackup.restore(pm);
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getHistoFramesChangedAfter: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
            fetchPlanBackup.restore(pm);
        }
    }

    public HistoFrame getHistoFrameOrFail(Uid histoFrameId) {
        HistoFrame histoFrame = this.getHistoFrame(histoFrameId);
        if (histoFrame == null) {
            throw new IllegalArgumentException(String.format("There is no HistoFrame with histoFrameId='%s'!", histoFrameId));
        }
        return histoFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoFrame getHistoFrame(Uid histoFrameId) {
        Objects.requireNonNull(histoFrameId, "histoFrameId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getHistoFrame_histoFrameId");
        try {
            HistoFrame result;
            HistoFrame histoFrame = result = (HistoFrame)((Object)query.execute((Object)histoFrameId.toString()));
            return histoFrame;
        }
        finally {
            query.closeAll();
        }
    }

    public void deletePersistent(HistoFrame entity) {
        super.deletePersistent((Entity)entity);
    }

    public void deletePersistentAll(Collection<? extends HistoFrame> entities) {
        super.deletePersistentAll(entities);
    }

    public HistoFrame getUnsealedHistoFrameOrFail(UUID fromRepositoryId) {
        HistoFrame histoFrame = this.getUnsealedHistoFrame(fromRepositoryId);
        if (histoFrame == null) {
            throw new IllegalStateException(String.format("There is no unsealed HistoFrame with fromRepositoryId='%s'!", fromRepositoryId));
        }
        return histoFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoFrame getUnsealedHistoFrame(UUID fromRepositoryId) {
        Objects.requireNonNull(fromRepositoryId, "fromRepositoryId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getHistoFrame_fromRepositoryId_sealed");
        try {
            HistoFrame result;
            HistoFrame histoFrame = result = (HistoFrame)((Object)query.execute((Object)fromRepositoryId.toString(), null));
            return histoFrame;
        }
        finally {
            query.closeAll();
        }
    }

    public Collection<HistoFrame> getHistoFrames(HistoFrameFilter filter) {
        Objects.requireNonNull(filter, "filter");
        if ("/".equals(filter.getLocalPath())) {
            filter.setLocalPath("");
        }
        HashSet<HistoFrame> result = new HashSet<HistoFrame>();
        if (!StringUtil.isEmpty((String)filter.getLocalPath())) {
            SsRemoteRepository remoteRepository = ((SsRemoteRepositoryDao)this.getDao(SsRemoteRepositoryDao.class)).getUniqueRemoteRepository();
            if (remoteRepository == null) {
                return result;
            }
            CryptoRepoFileDao crfDao = (CryptoRepoFileDao)this.getDao(CryptoRepoFileDao.class);
            CryptoRepoFile crf1 = crfDao.getCryptoRepoFile(remoteRepository, filter.getLocalPath());
            AssertUtil.assertNotNull((Object)((Object)crf1), (String)"cryptoRepoFile", (String)"remoteRepository=%s filter.localPath='%s'", (Object[])new Object[]{remoteRepository, filter.getLocalPath()});
            Set<Long> childCryptoRepoFileOids = crfDao.getChildCryptoRepoFileOidsRecursively(crf1);
            for (Set partialChildCryptoRepoFileOids : CollectionUtil.splitSet(childCryptoRepoFileOids, (int)1000)) {
                this.populateHistoFrames(result, filter, partialChildCryptoRepoFileOids);
            }
        } else {
            this.populateHistoFrames(result, filter, null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateHistoFrames(Set<HistoFrame> result, HistoFrameFilter filter, Set<Long> childCryptoRepoFileOids) {
        Objects.requireNonNull(result, "result");
        Objects.requireNonNull(filter, "filter");
        Query query = this.pm().newQuery(this.getEntityClass());
        try {
            StringBuilder q = new StringBuilder();
            HashMap<String, Object> p = new HashMap<String, Object>();
            HashMap<String, Class<HistoCryptoRepoFile>> v = new HashMap<String, Class<HistoCryptoRepoFile>>();
            if (filter.getMaxResultSize() > 0) {
                query.setRange(0L, (long)filter.getMaxResultSize());
                query.setOrdering("this.signature.signatureCreated DESC");
            }
            if (filter.getSignatureCreatedFrom() != null) {
                if (q.length() > 0) {
                    q.append(" && ");
                }
                q.append("this.signature.signatureCreated >= :signatureCreatedFrom");
                p.put("signatureCreatedFrom", filter.getSignatureCreatedFrom());
            }
            if (filter.getSignatureCreatedTo() != null) {
                if (q.length() > 0) {
                    q.append(" && ");
                }
                q.append("this.signature.signatureCreated < :signatureCreatedTo");
                p.put("signatureCreatedTo", filter.getSignatureCreatedTo());
            }
            if (childCryptoRepoFileOids != null) {
                if (q.length() > 0) {
                    q.append(" && ");
                }
                q.append("this == hcrf.histoFrame && :crfOids.contains(hcrf.cryptoRepoFile.id)");
                p.put("crfOids", childCryptoRepoFileOids);
                v.put("hcrf", HistoCryptoRepoFile.class);
            }
            if (!v.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry me : v.entrySet()) {
                    sb.append(((Class)me.getValue()).getName()).append(' ').append((String)me.getKey()).append(';');
                }
                query.declareVariables(sb.toString());
            }
            if (q.length() > 0) {
                query.setFilter(q.toString());
            }
            long startTimestamp = System.currentTimeMillis();
            Collection r = (List)query.executeWithMap(p);
            logger.debug("getHistoFrames: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            r = this.load(r);
            logger.debug("getHistoFrames: Loading result-set with {} elements took {} ms.", (Object)r.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            result.addAll(r);
        }
        finally {
            query.closeAll();
        }
    }
}

