/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto.internal.symmetric;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.subshare.crypto.AbstractCipher;
import org.subshare.crypto.CipherOperationMode;

public class AEADBlockCipherImpl
extends AbstractCipher {
    private final AEADBlockCipher delegate;
    private int ivSize = -1;

    public AEADBlockCipherImpl(String transformation, AEADBlockCipher delegate) {
        super(transformation);
        this.delegate = delegate;
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public int getInputBlockSize() {
        return this.delegate.getUnderlyingCipher().getBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.delegate.getUnderlyingCipher().getBlockSize();
    }

    @Override
    public int getUpdateOutputSize(int length) {
        return this.delegate.getUpdateOutputSize(length);
    }

    @Override
    public int getOutputSize(int length) {
        return this.delegate.getOutputSize(length);
    }

    @Override
    public int update(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        return this.delegate.processByte(in, out, outOff);
    }

    @Override
    public int update(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        return this.delegate.processBytes(in, inOff, inLen, out, outOff);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        return this.delegate.doFinal(out, outOff);
    }

    @Override
    public int getIVSize() {
        int ivSize = this.ivSize;
        if (ivSize < 0) {
            BlockCipher underlyingCipher = this.delegate.getUnderlyingCipher();
            ivSize = underlyingCipher instanceof CFBBlockCipher ? ((CFBBlockCipher)underlyingCipher).getUnderlyingCipher().getBlockSize() : (underlyingCipher instanceof OFBBlockCipher ? ((OFBBlockCipher)underlyingCipher).getUnderlyingCipher().getBlockSize() : underlyingCipher.getBlockSize());
            if (this.delegate instanceof CCMBlockCipher) {
                --ivSize;
            }
            this.ivSize = ivSize;
        }
        return ivSize;
    }

    @Override
    protected void _init(CipherOperationMode mode, CipherParameters parameters) throws IllegalArgumentException {
        this.delegate.init(CipherOperationMode.ENCRYPT == mode, parameters);
    }
}

