/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.server.service;

import co.codewizards.cloudstore.core.concurrent.CallableProvider;
import co.codewizards.cloudstore.core.concurrent.DeferrableExecutor;
import co.codewizards.cloudstore.core.repo.local.ContextWithLocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.rest.server.service.AbstractServiceWithRepoToRepoAuth;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactory;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.dto.CryptoChangeSetDto;
import org.subshare.core.dto.split.CryptoChangeSetDtoSplitFileManager;
import org.subshare.core.dto.split.CryptoChangeSetDtoSplitter;
import org.subshare.core.dto.split.CryptoChangeSetDtoTooLargeException;

@Path(value="_CryptoChangeSetDto/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class CryptoChangeSetDtoService
extends AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(CryptoChangeSetDtoService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public CryptoChangeSetDto getCryptoChangeSetDto(final @QueryParam(value="lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced") Long lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced) {
        final RepoTransport[] repoTransport = new RepoTransport[]{this.authenticateAndCreateLocalRepoTransport()};
        try {
            String callIdentifier = CryptoChangeSetDtoService.class.getName() + ".getCryptoChangeSetDto|" + this.repositoryName + "|" + this.getAuth().getUserName() + "|" + lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced;
            CryptoChangeSetDto cryptoChangeSetDto = (CryptoChangeSetDto)DeferrableExecutor.getInstance().call(callIdentifier, (CallableProvider)new CallableProvider<CryptoChangeSetDto>(){

                public Callable<CryptoChangeSetDto> getCallable() {
                    final RepoTransport rt = repoTransport[0];
                    repoTransport[0] = null;
                    return new Callable<CryptoChangeSetDto>(){

                        @Override
                        public CryptoChangeSetDto call() throws Exception {
                            try {
                                CryptoChangeSetDto cryptoChangeSetDto;
                                CryptoChangeSetDto cryptoChangeSetDto2 = cryptoChangeSetDto = CryptoChangeSetDtoService.this.getCryptoChangeSetDto(rt, lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced);
                                return cryptoChangeSetDto2;
                            }
                            finally {
                                rt.close();
                            }
                        }
                    };
                }
            });
            return cryptoChangeSetDto;
        }
        finally {
            if (repoTransport[0] != null) {
                repoTransport[0].close();
            }
        }
    }

    protected CryptoChangeSetDto getCryptoChangeSetDto(RepoTransport repoTransport, Long lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced) throws Exception {
        CryptoChangeSetDto cryptoChangeSetDto;
        int cryptoChangeSetDtoFinalFileCount;
        UUID clientRepositoryId = Objects.requireNonNull(repoTransport.getClientRepositoryId(), "clientRepositoryId");
        LocalRepoManager localRepoManager = ((ContextWithLocalRepoManager)repoTransport).getLocalRepoManager();
        CryptoChangeSetDtoSplitFileManager cryptoChangeSetDtoSplitFileManager = CryptoChangeSetDtoSplitFileManager.createInstance((LocalRepoManager)localRepoManager, (UUID)clientRepositoryId);
        if (!Objects.equals(lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced, cryptoChangeSetDtoSplitFileManager.readLastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced())) {
            cryptoChangeSetDtoSplitFileManager.deleteAll();
        }
        if ((cryptoChangeSetDtoFinalFileCount = cryptoChangeSetDtoSplitFileManager.getFinalFileCount()) > 0) {
            throw new CryptoChangeSetDtoTooLargeException(cryptoChangeSetDtoFinalFileCount);
        }
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            CryptreeFactory cryptreeFactory = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail();
            Cryptree cryptree = cryptreeFactory.getCryptreeOrCreate(transaction, clientRepositoryId);
            cryptree.initLocalRepositoryType();
            cryptree.prepareGetCryptoChangeSetDtoWithCryptoRepoFiles(lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced);
            transaction.commit();
        }
        try (LocalRepoTransaction transaction = localRepoManager.beginReadTransaction();){
            CryptreeFactory cryptreeFactory = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail();
            Cryptree cryptree = cryptreeFactory.getCryptreeOrCreate(transaction, clientRepositoryId);
            cryptoChangeSetDto = cryptree.getCryptoChangeSetDtoWithCryptoRepoFiles(lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced);
            transaction.commit();
        }
        CryptoChangeSetDtoSplitter cryptoChangeSetDtoSplitter = CryptoChangeSetDtoSplitter.createInstance((CryptoChangeSetDto)cryptoChangeSetDto);
        int maxCryptoChangeSetDtoSize = cryptoChangeSetDtoSplitter.getMaxCryptoChangeSetDtoSize();
        if (maxCryptoChangeSetDtoSize > 0 && cryptoChangeSetDto.size() > (long)maxCryptoChangeSetDtoSize) {
            List splitCryptoChangeSetDtos = cryptoChangeSetDtoSplitter.setDestroyInput(true).split().getOutCryptoChangeSetDtos();
            cryptoChangeSetDtoSplitFileManager.writeCryptoChangeSetDtos(splitCryptoChangeSetDtos, lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced);
            cryptoChangeSetDtoFinalFileCount = cryptoChangeSetDtoSplitFileManager.getFinalFileCount();
            if (cryptoChangeSetDtoFinalFileCount < 1) {
                throw new IllegalStateException("cryptoChangeSetDtoSplitFileManager.getFinalFileCount() < 1");
            }
            throw new CryptoChangeSetDtoTooLargeException(cryptoChangeSetDtoFinalFileCount);
        }
        return cryptoChangeSetDto;
    }

    @GET
    @Path(value="file/{multiPartIndex}")
    @Produces(value={"application/octet-stream"})
    public byte[] getCryptoChangeSetDtoFileData(@PathParam(value="multiPartIndex") int multiPartIndex) throws Exception {
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            byte[] result;
            UUID clientRepositoryId = Objects.requireNonNull(repoTransport.getClientRepositoryId(), "clientRepositoryId");
            LocalRepoManager localRepoManager = ((ContextWithLocalRepoManager)repoTransport).getLocalRepoManager();
            CryptoChangeSetDtoSplitFileManager cryptoChangeSetDtoSplitFileManager = CryptoChangeSetDtoSplitFileManager.createInstance((LocalRepoManager)localRepoManager, (UUID)clientRepositoryId);
            byte[] byArray = result = cryptoChangeSetDtoSplitFileManager.readCryptoChangeSetDtoFile(multiPartIndex);
            return byArray;
        }
    }

    @POST
    @Path(value="endGet")
    public void endGetCryptoChangeSetDto() throws Exception {
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            UUID clientRepositoryId = Objects.requireNonNull(repoTransport.getClientRepositoryId(), "clientRepositoryId");
            LocalRepoManager localRepoManager = ((ContextWithLocalRepoManager)repoTransport).getLocalRepoManager();
            try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
                CryptreeFactory cryptreeFactory = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail();
                Cryptree cryptree = cryptreeFactory.getCryptreeOrCreate(transaction, clientRepositoryId);
                cryptree.updateLastCryptoKeySyncToRemoteRepo();
                transaction.commit();
            }
            CryptoChangeSetDtoSplitFileManager.createInstance((LocalRepoManager)localRepoManager, (UUID)clientRepositoryId).deleteAll();
        }
    }

    @PUT
    public void putCryptoChangeSetDto(CryptoChangeSetDto cryptoChangeSetDto) {
        Objects.requireNonNull(cryptoChangeSetDto, "cryptoChangeSetDto");
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            UUID clientRepositoryId = Objects.requireNonNull(repoTransport.getClientRepositoryId(), "clientRepositoryId");
            LocalRepoManager localRepoManager = ((ContextWithLocalRepoManager)repoTransport).getLocalRepoManager();
            try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
                CryptreeFactory cryptreeFactory = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail();
                Cryptree cryptree = cryptreeFactory.getCryptreeOrCreate(transaction, clientRepositoryId);
                cryptree.putCryptoChangeSetDto(cryptoChangeSetDto);
                transaction.commit();
            }
        }
    }
}

