/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <E> List<Set<E>> splitSet(Set<E> inputSet, int maxSize) {
        Objects.requireNonNull(inputSet, "inputSet");
        if (maxSize < 1) {
            throw new IllegalArgumentException("maxSize < 1");
        }
        ArrayList result = new ArrayList(inputSet.size() / maxSize + 1);
        LinkedHashSet<E> current = null;
        for (E element : inputSet) {
            if (current == null || current.size() >= maxSize) {
                current = new LinkedHashSet<E>(maxSize);
                result.add(current);
            }
            current.add(element);
        }
        return result;
    }

    public static <E> List<List<E>> splitList(List<E> inputList, int maxSize) {
        Objects.requireNonNull(inputList, "inputList");
        if (maxSize < 1) {
            throw new IllegalArgumentException("maxSize < 1");
        }
        ArrayList result = new ArrayList(inputList.size() / maxSize + 1);
        ArrayList<E> current = null;
        for (E element : inputList) {
            if (current == null || current.size() >= maxSize) {
                current = new ArrayList<E>(maxSize);
                result.add(current);
            }
            current.add(element);
        }
        return result;
    }

    public static <E> List<E> nullToEmpty(List<E> list) {
        return list == null ? Collections.emptyList() : list;
    }

    public static <E> Set<E> nullToEmpty(Set<E> set) {
        return set == null ? Collections.emptySet() : set;
    }

    public static <E> Collection<E> nullToEmpty(Collection<E> collection) {
        return collection == null ? Collections.emptyList() : collection;
    }

    public static <E> Iterator<E> nullToEmpty(Iterator<E> iterator) {
        return iterator == null ? Collections.emptyList().iterator() : iterator;
    }

    @SafeVarargs
    public static <E> List<E> asListWithoutNullElements(E ... elements) {
        if (elements == null) {
            return Collections.emptyList();
        }
        ArrayList<E> result = new ArrayList<E>(elements.length);
        for (E element : elements) {
            if (element == null) continue;
            result.add(element);
        }
        result.trimToSize();
        return Collections.unmodifiableList(result);
    }
}

